/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.security.ACLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ACLConfigurationParser {
    private static final Logger LOG = LoggerFactory.getLogger(ACLConfigurationParser.class);
    private final Configuration conf;
    private final Map<ACLType, Set<String>> allowedUsers;
    private final Map<ACLType, Set<String>> allowedGroups;
    private static final Pattern splitPattern = Pattern.compile("\\s+");

    public ACLConfigurationParser(Configuration conf) {
        this(conf, false);
    }

    public ACLConfigurationParser(Configuration conf, boolean dagACLs) {
        this.conf = conf;
        this.allowedUsers = new HashMap<ACLType, Set<String>>(2);
        this.allowedGroups = new HashMap<ACLType, Set<String>>(2);
        this.parse(dagACLs);
    }

    private void parse(boolean dagACLs) {
        if (!dagACLs) {
            this.parseACLType("tez.am.view-acls", ACLType.AM_VIEW_ACL);
            this.parseACLType("tez.am.modify-acls", ACLType.AM_MODIFY_ACL);
        } else {
            this.parseACLType("tez.am.dag.view-acls", ACLType.DAG_VIEW_ACL);
            this.parseACLType("tez.am.dag.modify-acls", ACLType.DAG_MODIFY_ACL);
        }
    }

    private boolean isWildCard(String aclStr) {
        return aclStr.trim().equals("*");
    }

    private void parseACLType(String configProperty, ACLType aclType) {
        String aclsStr = this.conf.get(configProperty);
        if (aclsStr == null || aclsStr.isEmpty()) {
            return;
        }
        if (this.isWildCard(aclsStr)) {
            this.allowedUsers.put(aclType, Sets.newHashSet((Object[])new String[]{"*"}));
            return;
        }
        String[] splits = splitPattern.split(aclsStr);
        int counter = -1;
        String userListStr = null;
        String groupListStr = null;
        for (String s : splits) {
            if (s.isEmpty() && userListStr != null) continue;
            if (++counter == 0) {
                userListStr = s;
                continue;
            }
            if (counter == 1) {
                groupListStr = s;
                continue;
            }
            LOG.warn("Invalid configuration specified for " + configProperty + ", ignoring configured ACLs, value=" + aclsStr);
            return;
        }
        if (userListStr == null) {
            return;
        }
        if (userListStr.length() >= 1) {
            this.allowedUsers.put(aclType, Sets.newLinkedHashSet(Arrays.asList(TezCommonUtils.getTrimmedStrings(userListStr))));
        }
        if (groupListStr != null && groupListStr.length() >= 1) {
            this.allowedGroups.put(aclType, Sets.newLinkedHashSet(Arrays.asList(TezCommonUtils.getTrimmedStrings(groupListStr))));
        }
    }

    public Map<ACLType, Set<String>> getAllowedUsers() {
        return Collections.unmodifiableMap(this.allowedUsers);
    }

    public Map<ACLType, Set<String>> getAllowedGroups() {
        return Collections.unmodifiableMap(this.allowedGroups);
    }

    public void addAllowedUsers(Map<ACLType, Set<String>> additionalAllowedUsers) {
        for (Map.Entry<ACLType, Set<String>> entry : additionalAllowedUsers.entrySet()) {
            if (this.allowedUsers.containsKey((Object)entry.getKey())) {
                this.allowedUsers.get((Object)entry.getKey()).addAll((Collection<String>)entry.getValue());
                continue;
            }
            this.allowedUsers.put(entry.getKey(), entry.getValue());
        }
    }

    public void addAllowedGroups(Map<ACLType, Set<String>> additionalAllowedGroups) {
        for (Map.Entry<ACLType, Set<String>> entry : additionalAllowedGroups.entrySet()) {
            if (this.allowedGroups.containsKey((Object)entry.getKey())) {
                this.allowedGroups.get((Object)entry.getKey()).addAll((Collection<String>)entry.getValue());
                continue;
            }
            this.allowedGroups.put(entry.getKey(), entry.getValue());
        }
    }
}

