/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.tez.common.security.ACLConfigurationParser;
import org.apache.tez.common.security.ACLType;

@InterfaceAudience.Private
public class ACLManager {
    private static final Log LOG = LogFactory.getLog(ACLManager.class);
    public static final String WILDCARD_ACL_VALUE = "*";
    private final String dagUser;
    private final String amUser;
    private final Map<ACLType, Set<String>> users;
    private final Map<ACLType, Set<String>> groups;
    private final boolean aclsEnabled;

    public ACLManager(String amUser) {
        this(amUser, new Configuration(false));
    }

    public ACLManager(String amUser, Configuration conf) {
        this.amUser = amUser;
        this.dagUser = null;
        this.users = new HashMap<ACLType, Set<String>>();
        this.groups = new HashMap<ACLType, Set<String>>();
        this.aclsEnabled = conf.getBoolean("tez.am.acls.enabled", true);
        if (!this.aclsEnabled) {
            return;
        }
        ACLConfigurationParser parser = new ACLConfigurationParser(conf);
        if (parser.getAllowedUsers() != null) {
            this.users.putAll(parser.getAllowedUsers());
        }
        if (parser.getAllowedGroups() != null) {
            this.groups.putAll(parser.getAllowedGroups());
        }
    }

    public ACLManager(ACLManager amACLManager, String dagUser, Configuration dagConf) {
        this.amUser = amACLManager.amUser;
        this.dagUser = dagUser;
        this.users = amACLManager.users;
        this.groups = amACLManager.groups;
        this.aclsEnabled = amACLManager.aclsEnabled;
        if (!this.aclsEnabled) {
            return;
        }
        ACLConfigurationParser parser = new ACLConfigurationParser(dagConf, true);
        if (parser.getAllowedUsers() != null) {
            this.users.putAll(parser.getAllowedUsers());
        }
        if (parser.getAllowedGroups() != null) {
            this.groups.putAll(parser.getAllowedGroups());
        }
    }

    public boolean isAclsEnabled() {
        return this.aclsEnabled;
    }

    @VisibleForTesting
    boolean checkAccess(UserGroupInformation ugi, ACLType aclType) {
        Set<String> set;
        List<String> userGroups;
        Set<String> set2;
        if (!this.aclsEnabled) {
            return true;
        }
        String user = ugi.getShortUserName();
        if (this.amUser.equals(user)) {
            return true;
        }
        if (EnumSet.of(ACLType.DAG_MODIFY_ACL, ACLType.DAG_VIEW_ACL).contains((Object)aclType) && this.dagUser != null && this.dagUser.equals(user)) {
            return true;
        }
        if (this.users != null && !this.users.isEmpty() && (set2 = this.users.get((Object)aclType)) != null) {
            if (set2.contains(WILDCARD_ACL_VALUE)) {
                return true;
            }
            if (set2.contains(user)) {
                return true;
            }
        }
        if ((userGroups = Arrays.asList(ugi.getGroupNames())) != null && !userGroups.isEmpty() && this.groups != null && !this.groups.isEmpty() && (set = this.groups.get((Object)aclType)) != null) {
            for (String userGrp : userGroups) {
                if (!set.contains(userGrp)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkAMViewAccess(UserGroupInformation ugi) {
        return this.checkAccess(ugi, ACLType.AM_VIEW_ACL);
    }

    public boolean checkAMModifyAccess(UserGroupInformation ugi) {
        return this.checkAccess(ugi, ACLType.AM_MODIFY_ACL);
    }

    public boolean checkDAGViewAccess(UserGroupInformation ugi) {
        return this.checkAccess(ugi, ACLType.AM_VIEW_ACL) || this.checkAccess(ugi, ACLType.DAG_VIEW_ACL);
    }

    public boolean checkDAGModifyAccess(UserGroupInformation ugi) {
        return this.checkAccess(ugi, ACLType.AM_MODIFY_ACL) || this.checkAccess(ugi, ACLType.DAG_MODIFY_ACL);
    }

    public Map<ApplicationAccessType, String> toYARNACls() {
        String aclsStr;
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        if (!this.aclsEnabled) {
            acls.put(ApplicationAccessType.VIEW_APP, WILDCARD_ACL_VALUE);
            acls.put(ApplicationAccessType.MODIFY_APP, WILDCARD_ACL_VALUE);
            return acls;
        }
        acls.put(ApplicationAccessType.VIEW_APP, this.amUser);
        acls.put(ApplicationAccessType.MODIFY_APP, this.amUser);
        boolean viewAclsWildCard = false;
        boolean modifyAclsWildCard = false;
        if (this.users != null && !this.users.isEmpty()) {
            for (Map.Entry<ACLType, Set<String>> entry : this.users.entrySet()) {
                String commaSepList;
                if (entry.getKey().equals((Object)ACLType.AM_VIEW_ACL)) {
                    if (entry.getValue().contains(WILDCARD_ACL_VALUE)) {
                        acls.put(ApplicationAccessType.VIEW_APP, WILDCARD_ACL_VALUE);
                        viewAclsWildCard = true;
                        continue;
                    }
                    if (entry.getValue().isEmpty()) continue;
                    aclsStr = (String)acls.get(ApplicationAccessType.VIEW_APP);
                    commaSepList = ACLManager.toCommaSeparatedString((Collection<String>)entry.getValue());
                    if (!commaSepList.isEmpty()) {
                        aclsStr = aclsStr + "," + commaSepList;
                    }
                    acls.put(ApplicationAccessType.VIEW_APP, aclsStr);
                    continue;
                }
                if (!entry.getKey().equals((Object)ACLType.AM_MODIFY_ACL)) continue;
                if (entry.getValue().contains(WILDCARD_ACL_VALUE)) {
                    acls.put(ApplicationAccessType.MODIFY_APP, WILDCARD_ACL_VALUE);
                    modifyAclsWildCard = true;
                    continue;
                }
                if (entry.getValue().isEmpty()) continue;
                aclsStr = (String)acls.get(ApplicationAccessType.MODIFY_APP);
                commaSepList = ACLManager.toCommaSeparatedString((Collection<String>)entry.getValue());
                if (!commaSepList.isEmpty()) {
                    aclsStr = aclsStr + "," + commaSepList;
                }
                acls.put(ApplicationAccessType.MODIFY_APP, aclsStr);
            }
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            for (Map.Entry<ACLType, Set<String>> entry : this.groups.entrySet()) {
                if (entry.getKey().equals((Object)ACLType.AM_VIEW_ACL) && !viewAclsWildCard && !entry.getValue().isEmpty()) {
                    aclsStr = acls.containsKey(ApplicationAccessType.VIEW_APP) ? (String)acls.get(ApplicationAccessType.VIEW_APP) : "";
                    aclsStr = aclsStr + " " + ACLManager.toCommaSeparatedString((Collection<String>)entry.getValue());
                    acls.put(ApplicationAccessType.VIEW_APP, aclsStr);
                    continue;
                }
                if (!entry.getKey().equals((Object)ACLType.AM_MODIFY_ACL) || modifyAclsWildCard || entry.getValue().isEmpty()) continue;
                aclsStr = acls.containsKey(ApplicationAccessType.MODIFY_APP) ? (String)acls.get(ApplicationAccessType.MODIFY_APP) : "";
                aclsStr = aclsStr + " " + ACLManager.toCommaSeparatedString((Collection<String>)entry.getValue());
                acls.put(ApplicationAccessType.MODIFY_APP, aclsStr);
            }
        }
        return acls;
    }

    public static String toCommaSeparatedString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : collection) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

