/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.UserPayload;

@InterfaceAudience.Public
public abstract class EntityDescriptor<T extends EntityDescriptor<T>>
implements Writable {
    private UserPayload userPayload = null;
    private String className;
    protected String historyText;

    @InterfaceAudience.Private
    public EntityDescriptor() {
    }

    public EntityDescriptor(String className) {
        this.className = className;
    }

    public UserPayload getUserPayload() {
        return this.userPayload;
    }

    public T setUserPayload(UserPayload userPayload) {
        Preconditions.checkNotNull((Object)userPayload);
        this.userPayload = userPayload;
        return (T)this;
    }

    public T setHistoryText(String historyText) {
        this.historyText = historyText;
        return (T)this;
    }

    @InterfaceAudience.Private
    public String getHistoryText() {
        return this.historyText;
    }

    public String getClassName() {
        return this.className;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.className);
        ByteBuffer bb = DagTypeConverters.convertFromTezUserPayload(this.userPayload);
        if (bb == null) {
            out.writeInt(-1);
        } else {
            int size = bb.limit() - bb.position();
            if (size == 0) {
                out.writeInt(-1);
            } else {
                out.writeInt(size);
                byte[] bytes = new byte[size];
                bb.get(bytes);
                out.write(bytes);
            }
            out.writeInt(this.userPayload.getVersion());
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.className = Text.readString((DataInput)in);
        int payloadLength = in.readInt();
        if (payloadLength != -1) {
            byte[] bb = new byte[payloadLength];
            in.readFully(bb);
            int version = in.readInt();
            this.userPayload = DagTypeConverters.convertToTezUserPayload(ByteBuffer.wrap(bb), version);
        }
    }

    public String toString() {
        boolean hasPayload = this.userPayload == null ? false : this.userPayload.getPayload() != null;
        return "ClassName=" + this.className + ", hasPayload=" + hasPayload;
    }
}

