/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.dag.api.TezConfiguration;

@InterfaceAudience.Private
public class TezYarnClient
extends FrameworkClient {
    private final YarnClient yarnClient;

    protected TezYarnClient(YarnClient yarnClient) {
        this.yarnClient = yarnClient;
    }

    @Override
    public void init(TezConfiguration tezConf, YarnConfiguration yarnConf) {
        this.yarnClient.init((Configuration)yarnConf);
    }

    @Override
    public void start() {
        this.yarnClient.start();
    }

    @Override
    public void stop() {
        this.yarnClient.stop();
    }

    @Override
    public final void close() throws IOException {
        this.yarnClient.close();
    }

    @Override
    public YarnClientApplication createApplication() throws YarnException, IOException {
        return this.yarnClient.createApplication();
    }

    @Override
    public ApplicationId submitApplication(ApplicationSubmissionContext appSubmissionContext) throws YarnException, IOException {
        ApplicationId appId = this.yarnClient.submitApplication(appSubmissionContext);
        ApplicationReport appReport = this.getApplicationReport(appId);
        if (appReport.getYarnApplicationState() == YarnApplicationState.FAILED) {
            throw new IOException("Failed to submit application to YARN: " + appReport.getDiagnostics());
        }
        return appId;
    }

    @Override
    public void killApplication(ApplicationId appId) throws YarnException, IOException {
        this.yarnClient.killApplication(appId);
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        return this.yarnClient.getApplicationReport(appId);
    }
}

