/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.runtime.api.Event;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class InputInitializerEvent
extends Event {
    private String targetVertexName;
    private String targetInputName;
    private ByteBuffer eventPayload;

    private InputInitializerEvent(String targetVertexName, String targetInputName, ByteBuffer eventPayload) {
        Preconditions.checkNotNull((Object)targetVertexName, (Object)"TargetVertexName cannot be null");
        Preconditions.checkNotNull((Object)targetInputName, (Object)"TargetInputName cannot be null");
        this.targetVertexName = targetVertexName;
        this.targetInputName = targetInputName;
        this.eventPayload = eventPayload;
    }

    public static InputInitializerEvent create(String targetVertexName, String targetInputName, ByteBuffer eventPayload) {
        return new InputInitializerEvent(targetVertexName, targetInputName, eventPayload);
    }

    public String getTargetVertexName() {
        return this.targetVertexName;
    }

    public String getTargetInputName() {
        return this.targetInputName;
    }

    public ByteBuffer getUserPayload() {
        return this.eventPayload == null ? null : this.eventPayload.asReadOnlyBuffer();
    }
}

