/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.runtime.api.Event;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public final class InputDataInformationEvent
extends Event {
    private final int sourceIndex;
    private int targetIndex;
    private final ByteBuffer userPayload;
    private final Object userPayloadObject;

    private InputDataInformationEvent(int srcIndex, ByteBuffer userPayload) {
        this.sourceIndex = srcIndex;
        this.userPayload = userPayload;
        this.userPayloadObject = null;
    }

    private InputDataInformationEvent(int srcIndex, Object userPayloadDeserialized, Object sigChanged) {
        this.sourceIndex = srcIndex;
        this.userPayloadObject = userPayloadDeserialized;
        this.userPayload = null;
    }

    public static InputDataInformationEvent createWithSerializedPayload(int srcIndex, ByteBuffer userPayload) {
        return new InputDataInformationEvent(srcIndex, userPayload);
    }

    public static InputDataInformationEvent createWithObjectPayload(int srcIndex, Object userPayloadDeserialized) {
        return new InputDataInformationEvent(srcIndex, userPayloadDeserialized, null);
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    public void setTargetIndex(int target) {
        this.targetIndex = target;
    }

    public ByteBuffer getUserPayload() {
        return this.userPayload == null ? null : this.userPayload.asReadOnlyBuffer();
    }

    public Object getDeserializedUserPayload() {
        return this.userPayloadObject;
    }

    public String toString() {
        return "InputDataInformationEvent [sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", serializedUserPayloadExists=" + (this.userPayload != null) + ", deserializedUserPayloadExists=" + (this.userPayloadObject != null) + "]";
    }
}

