/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.Master;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TokenCache {
    private static final Log LOG = LogFactory.getLog(TokenCache.class);
    private static final Text SESSION_TOKEN = new Text("SessionToken");

    public static byte[] getSecretKey(Credentials credentials, Text alias) {
        if (credentials == null) {
            return null;
        }
        return credentials.getSecretKey(alias);
    }

    public static void obtainTokensForFileSystems(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        TokenCache.obtainTokensForFileSystemsInternal(credentials, ps, conf);
    }

    static void obtainTokensForFileSystemsInternal(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        HashSet<FileSystem> fsSet = new HashSet<FileSystem>();
        for (Path p : ps) {
            fsSet.add(p.getFileSystem(conf));
        }
        for (FileSystem fs : fsSet) {
            TokenCache.obtainTokensForFileSystemsInternal(fs, credentials, conf);
        }
    }

    static void obtainTokensForFileSystemsInternal(FileSystem fs, Credentials credentials, Configuration conf) throws IOException {
        String delegTokenRenewer = Master.getMasterPrincipal(conf);
        if (delegTokenRenewer == null || delegTokenRenewer.length() == 0) {
            throw new IOException("Can't get Master Kerberos principal for use as renewer");
        }
        Token[] tokens = fs.addDelegationTokens(delegTokenRenewer, credentials);
        if (tokens != null) {
            for (Token token : tokens) {
                LOG.info((Object)("Got dt for " + fs.getUri() + "; " + token));
            }
        }
    }

    @InterfaceAudience.Private
    public static void setSessionToken(Token<? extends TokenIdentifier> t, Credentials credentials) {
        credentials.addToken(SESSION_TOKEN, t);
    }

    @InterfaceAudience.Private
    public static Token<JobTokenIdentifier> getSessionToken(Credentials credentials) {
        Token token = credentials.getToken(SESSION_TOKEN);
        if (token == null) {
            return null;
        }
        return token;
    }

    @InterfaceAudience.Private
    public static void mergeBinaryTokens(Credentials creds, Configuration conf, String tokenFilePath) throws IOException {
        if (tokenFilePath == null || tokenFilePath.isEmpty()) {
            throw new RuntimeException("Invalid file path provided, tokenFilePath=" + tokenFilePath);
        }
        LOG.info((Object)("Merging additional tokens from binary file, binaryFileName=" + tokenFilePath));
        Credentials binary = Credentials.readTokenStorageFile((Path)new Path("file:///" + tokenFilePath), (Configuration)conf);
        creds.mergeAll(binary);
    }
}

