/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.BindingException;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidMessages;

public abstract class FieldLabel
extends AbstractComponent {
    public abstract boolean isPrerender();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = TapestryUtils.getForm(cycle, this);
        IFormComponent field = this.getField();
        if (field != null && this.isPrerender()) {
            form.prerenderField(writer, field, this.getLocation());
        }
        if (cycle.isRewinding()) {
            return;
        }
        String displayName = this.getDisplayName();
        if (displayName == null) {
            if (field == null) {
                throw Tapestry.createRequiredParameterException(this, "field");
            }
            displayName = field.getDisplayName();
            if (displayName == null) {
                throw new BindingException(ValidMessages.noDisplayName(this, field), this, null, this.getBinding("field"), null);
            }
        }
        IValidationDelegate delegate = form.getDelegate();
        String id = field == null ? null : field.getClientId();
        delegate.writeLabelPrefix(field, writer, cycle);
        writer.begin("label");
        if (id != null) {
            writer.attribute("for", id);
        }
        delegate.writeLabelAttributes(writer, cycle, field);
        this.renderInformalParameters(writer, cycle);
        writer.print(displayName, this.getRaw());
        writer.end();
        delegate.writeLabelSuffix(field, writer, cycle);
    }

    public abstract String getDisplayName();

    public abstract IFormComponent getField();

    public abstract boolean getRaw();
}

