/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.util.text.LocalizedPropertiesLoader;

public class LocalizedProperties {
    private Map _propertyMap;

    public LocalizedProperties() {
        this(new HashMap());
    }

    public LocalizedProperties(Map propertyMap) {
        this._propertyMap = propertyMap;
    }

    public String getProperty(String key) {
        Object value = this._propertyMap.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void setProperty(String key, String value) {
        this._propertyMap.put(key, value);
    }

    public Map getPropertyMap() {
        return this._propertyMap;
    }

    public void load(InputStream ins) throws IOException {
        LocalizedPropertiesLoader loader = new LocalizedPropertiesLoader(ins);
        loader.load(this._propertyMap);
    }

    public void load(InputStream ins, String encoding) throws IOException {
        LocalizedPropertiesLoader loader = new LocalizedPropertiesLoader(ins, encoding);
        loader.load(this._propertyMap);
    }

    public void load(Reader reader) throws IOException {
        LocalizedPropertiesLoader loader = new LocalizedPropertiesLoader(reader);
        loader.load(this._propertyMap);
    }
}

