/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.text;

import java.io.IOException;
import java.io.Reader;
import org.apache.tapestry.util.text.ICharacterMatcher;

public class ExtendedReader
extends Reader {
    private Reader _reader;
    private boolean _hasBufferedChar = false;
    private char _bufferedChar;

    public ExtendedReader(Reader in) {
        this._reader = in;
    }

    public synchronized int peek() throws IOException {
        if (!this._hasBufferedChar) {
            int bufferedChar = this.read();
            if (bufferedChar < 0) {
                return bufferedChar;
            }
            this._bufferedChar = (char)bufferedChar;
            this._hasBufferedChar = true;
        }
        return this._bufferedChar;
    }

    public synchronized boolean isEndOfStream() throws IOException {
        return this.peek() < 0;
    }

    public synchronized void skipCharacters(ICharacterMatcher matcher) throws IOException {
        char ch;
        while (!this.isEndOfStream() && matcher.matches(ch = (char)this.peek())) {
            this.read();
        }
    }

    public synchronized String readCharacters(ICharacterMatcher matcher) throws IOException {
        char ch;
        StringBuffer buf = new StringBuffer();
        while (!this.isEndOfStream() && matcher.matches(ch = (char)this.peek())) {
            buf.append(this.read());
        }
        return buf.toString();
    }

    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int offset = off;
        if (len <= 0) {
            return 0;
        }
        int readLength = len;
        boolean extraChar = this._hasBufferedChar;
        if (this._hasBufferedChar) {
            this._hasBufferedChar = false;
            cbuf[offset++] = this._bufferedChar;
            --readLength;
        }
        int read = this._reader.read(cbuf, offset, readLength);
        if (extraChar) {
            ++read;
        }
        return read;
    }

    public synchronized boolean ready() throws IOException {
        if (this._hasBufferedChar) {
            return true;
        }
        return this._reader.ready();
    }

    public synchronized boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        this._hasBufferedChar = false;
        this._reader.reset();
    }

    public synchronized long skip(long n) throws IOException {
        long skipChars = n;
        if (this._hasBufferedChar && skipChars > 0L) {
            this._hasBufferedChar = false;
            --skipChars;
        }
        return this._reader.skip(skipChars);
    }

    public synchronized void close() throws IOException {
        this._hasBufferedChar = false;
        this._reader.close();
    }
}

