/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.io;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.util.ComponentAddress;
import org.apache.tapestry.util.io.SqueezeAdaptor;

public class ComponentAddressAdaptor
implements SqueezeAdaptor {
    private static final String PREFIX = "A";
    private static final char SEPARATOR = ',';

    public String getPrefix() {
        return PREFIX;
    }

    public Class getDataClass() {
        return ComponentAddress.class;
    }

    public String squeeze(DataSqueezer squeezer, Object data) {
        ComponentAddress address = (ComponentAddress)data;
        String idPath = address.getIdPath();
        if (idPath == null) {
            idPath = "";
        }
        return PREFIX + address.getPageName() + ',' + idPath;
    }

    public Object unsqueeze(DataSqueezer squeezer, String string) {
        int separator = string.indexOf(44);
        if (separator < 0) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("ComponentAddressAdaptor.no-separator"));
        }
        String pageName = string.substring(1, separator);
        String idPath = string.substring(separator + 1);
        if (idPath.equals("")) {
            idPath = null;
        }
        return new ComponentAddress(pageName, idPath);
    }
}

