/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public class Strftime {
    protected static Properties translate = new Properties();
    protected static Properties pTranslate;
    protected SimpleDateFormat simpleDateFormat;

    public Strftime(String origFormat) {
        String convertedFormat = Strftime.convertDateFormat(origFormat);
        this.simpleDateFormat = new SimpleDateFormat(convertedFormat);
    }

    public Strftime(String origFormat, Locale locale) {
        String convertedFormat = Strftime.convertDateFormat(origFormat);
        this.simpleDateFormat = new SimpleDateFormat(convertedFormat, locale);
    }

    public String format(Date date) {
        return this.simpleDateFormat.format(date);
    }

    public Date parse(String input) throws ParseException {
        return this.simpleDateFormat.parse(input);
    }

    public TimeZone getTimeZone() {
        return this.simpleDateFormat.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.simpleDateFormat.setTimeZone(timeZone);
    }

    public static String convertToPosixFormat(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int start = -1;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetter(c)) {
                if (start > -1) continue;
                start = i;
                continue;
            }
            if (start >= 0) {
                String conv = pattern.substring(start, i);
                String match = pTranslate.getProperty(conv);
                if (match == null) {
                    buf.append(conv);
                } else {
                    buf.append(match);
                }
                start = -1;
            }
            buf.append(c);
        }
        if (start > -1) {
            String conv = pattern.substring(start, pattern.length());
            String match = pTranslate.getProperty(conv);
            if (match == null) {
                buf.append(conv);
            } else {
                buf.append(match);
            }
        }
        return buf.toString();
    }

    public static String convertDateFormat(String pattern) {
        char lastChar;
        boolean inside = false;
        boolean mark = false;
        boolean modifiedCommand = false;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '%' && !mark) {
                mark = true;
                continue;
            }
            if (mark) {
                if (modifiedCommand) {
                    modifiedCommand = false;
                    mark = false;
                    continue;
                }
                inside = Strftime.translateCommand(buf, pattern, i, inside);
                if (c == 'O' || c == 'E') {
                    modifiedCommand = true;
                    continue;
                }
                mark = false;
                continue;
            }
            if (!inside && c != ' ') {
                buf.append("'");
                inside = true;
            }
            buf.append(c);
        }
        if (buf.length() > 0 && (lastChar = buf.charAt(buf.length() - 1)) != '\'' && inside) {
            buf.append('\'');
        }
        return buf.toString();
    }

    private static String quote(String str, boolean insideQuotes) {
        String retVal = str;
        if (!insideQuotes) {
            retVal = '\'' + retVal + '\'';
        }
        return retVal;
    }

    private static boolean translateCommand(StringBuffer buf, String pattern, int index, boolean oldInside) {
        char firstChar = pattern.charAt(index);
        boolean newInside = oldInside;
        if (firstChar == 'O' || firstChar == 'E') {
            if (index + 1 < pattern.length()) {
                newInside = Strftime.translateCommand(buf, pattern, index + 1, oldInside);
            } else {
                buf.append(Strftime.quote("%" + firstChar, oldInside));
            }
        } else {
            String command = translate.getProperty(String.valueOf(firstChar));
            if (command == null) {
                buf.append(Strftime.quote("%" + firstChar, oldInside));
            } else {
                if (oldInside) {
                    buf.append('\'');
                }
                buf.append(command);
                newInside = false;
            }
        }
        return newInside;
    }

    static {
        translate.put("a", "EEE");
        translate.put("A", "EEEE");
        translate.put("b", "MMM");
        translate.put("B", "MMMM");
        translate.put("c", "EEE MMM d HH:mm:ss yyyy");
        translate.put("d", "dd");
        translate.put("D", "MM/dd/yy");
        translate.put("e", "dd");
        translate.put("F", "yyyy-MM-dd");
        translate.put("g", "yy");
        translate.put("G", "yyyy");
        translate.put("H", "HH");
        translate.put("h", "MMM");
        translate.put("I", "hh");
        translate.put("j", "DDD");
        translate.put("k", "HH");
        translate.put("l", "hh");
        translate.put("m", "MM");
        translate.put("M", "mm");
        translate.put("n", "\n");
        translate.put("p", "a");
        translate.put("P", "a");
        translate.put("r", "hh:mm:ss a");
        translate.put("R", "HH:mm");
        translate.put("S", "ss");
        translate.put("t", "\t");
        translate.put("T", "HH:mm:ss");
        translate.put("V", "ww");
        translate.put("X", "HH:mm:ss");
        translate.put("x", "MM/dd/yy");
        translate.put("y", "yy");
        translate.put("Y", "yyyy");
        translate.put("Z", "z");
        translate.put("z", "Z");
        translate.put("%", "%");
        pTranslate = new Properties();
        pTranslate.put("EEE", "%a");
        pTranslate.put("EEEE", "%A");
        pTranslate.put("MMM", "%b");
        pTranslate.put("MMMM", "%B");
        pTranslate.put("EEE MMM d HH:mm:ss yyyy", "%c");
        pTranslate.put("dd", "%d");
        pTranslate.put("MM/dd/yy", "%D");
        pTranslate.put("yyyy-MM-dd", "%F");
        pTranslate.put("yy", "%g");
        pTranslate.put("yyyy", "%G");
        pTranslate.put("HH", "%H");
        pTranslate.put("MMM", "%h");
        pTranslate.put("hh", "%I");
        pTranslate.put("DDD", "%j");
        pTranslate.put("MM", "%m");
        pTranslate.put("mm", "%M");
        pTranslate.put("\n", "%n");
        pTranslate.put("a", "%p");
        pTranslate.put("hh:mm:ss a", "%r");
        pTranslate.put("HH:mm", "%R");
        pTranslate.put("ss", "%S");
        pTranslate.put("\t", "%t");
        pTranslate.put("HH:mm:ss", "%T");
        pTranslate.put("ww", "%V");
        pTranslate.put("HH:mm:ss", "%X");
        pTranslate.put("MM/dd/yy", "%x");
        pTranslate.put("yy", "%y");
        pTranslate.put("yyyy", "%Y");
        pTranslate.put("z", "%Z");
        pTranslate.put("Z", "%z");
        pTranslate.put("%", "%");
    }
}

