/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class ScriptUtils {
    public static final String BEGIN_COMMENT = "\n<script>\n//<![CDATA[\n";
    public static final String END_COMMENT = "\n//]]>\n</script>\n";
    public static final Pattern SCRIPT_PATTERN = Pattern.compile("(?:<script.*?>)(.*?)(?:<\\/script>)", 44);

    private ScriptUtils() {
    }

    public static synchronized String ensureValidScriptTags(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = SCRIPT_PATTERN.matcher(input);
        StringBuffer buffer = new StringBuffer(input.length());
        boolean matched = false;
        int end = 0;
        while (matcher.find()) {
            matched = true;
            String str = matcher.group(1);
            int pos = matcher.start() - end;
            end = matcher.end();
            if (str == null || str.trim().equals("")) {
                matcher.appendReplacement(buffer, "");
                continue;
            }
            StringBuffer matchLocal = new StringBuffer();
            matcher.appendReplacement(matchLocal, "\n<script>\n//<![CDATA[\n$1\n//]]>\n</script>\n");
            String curr = matchLocal.toString();
            String prefix = curr.substring(0, pos);
            String suffix = curr.substring(pos);
            suffix = StringUtils.replace((String)suffix, (String)"<!--", (String)"");
            suffix = StringUtils.replace((String)suffix, (String)"// -->", (String)"");
            buffer.append(prefix).append(suffix);
        }
        if (!matched) {
            buffer.append(input);
        } else {
            matcher.appendTail(buffer);
        }
        return buffer.toString();
    }
}

