/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.spec.IExtensionSpecification;
import org.apache.tapestry.spec.LocatablePropertyHolder;

public class ExtensionSpecification
extends LocatablePropertyHolder
implements IExtensionSpecification {
    private static final Log LOG = LogFactory.getLog(ExtensionSpecification.class);
    protected Map _configuration = new HashMap();
    private String _className;
    private boolean _immediate;
    private ClassResolver _resolver;
    private ValueConverter _converter;

    public ExtensionSpecification(ClassResolver resolver, ValueConverter valueConverter) {
        this._resolver = resolver;
        this._converter = valueConverter;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void addConfiguration(String propertyName, String value) {
        if (this._configuration.containsKey(propertyName)) {
            throw new IllegalArgumentException(Tapestry.format("ExtensionSpecification.duplicate-property", this, propertyName));
        }
        this._configuration.put(propertyName, value);
    }

    public Map getConfiguration() {
        return Collections.unmodifiableMap(this._configuration);
    }

    public Object instantiateExtension() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiating extension class " + this._className + "."));
        }
        Class extensionClass = null;
        Object result = null;
        try {
            extensionClass = this._resolver.findClass(this._className);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ExtensionSpecification.bad-class", this._className), this.getLocation(), (Throwable)ex);
        }
        result = this.instantiateInstance(extensionClass, result);
        this.initializeProperties(result);
        return result;
    }

    private void initializeProperties(Object extension) {
        for (Map.Entry entry : this._configuration.entrySet()) {
            String propertyName = (String)entry.getKey();
            String textValue = (String)entry.getValue();
            try {
                Class propertyType = PropertyUtils.getPropertyType((Object)extension, (String)propertyName);
                Object objectValue = this._converter.coerceValue(textValue, propertyType);
                PropertyUtils.write((Object)extension, (String)propertyName, (Object)objectValue);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(ex.getMessage(), this.getLocation(), (Throwable)ex);
            }
        }
    }

    private Object instantiateInstance(Class extensionClass, Object result) {
        Object returnResult = result;
        try {
            returnResult = extensionClass.newInstance();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), this.getLocation(), (Throwable)ex);
        }
        return returnResult;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ExtensionSpecification@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        buffer.append(this._className);
        if (this._configuration != null) {
            buffer.append(' ');
            buffer.append(this._configuration);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public boolean isImmediate() {
        return this._immediate;
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate;
    }
}

