/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.IOException;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorHandler;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.RequestCycle;
import org.apache.tapestry.engine.RequestCycleEnvironment;
import org.apache.tapestry.engine.ServiceEncoder;
import org.apache.tapestry.engine.ServiceEncodingImpl;
import org.apache.tapestry.record.PropertyPersistenceStrategySource;
import org.apache.tapestry.services.AbsoluteURLBuilder;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.services.RequestCycleFactory;
import org.apache.tapestry.services.RequestGlobals;
import org.apache.tapestry.services.ResponseDelegateFactory;
import org.apache.tapestry.util.QueryParameterMap;
import org.apache.tapestry.web.WebRequest;

public class RequestCycleFactoryImpl
implements RequestCycleFactory {
    private ServiceEncoder[] _encoders;
    private PropertyPersistenceStrategySource _strategySource;
    private ErrorHandler _errorHandler;
    private Infrastructure _infrastructure;
    private AbsoluteURLBuilder _absoluteURLBuilder;
    private RequestCycleEnvironment _environment;
    private RequestGlobals _requestGlobals;
    private ResponseDelegateFactory _responseDelegateFactory;

    public void initializeService() {
        this._environment = new RequestCycleEnvironment(this._errorHandler, this._infrastructure, this._strategySource, this._absoluteURLBuilder);
    }

    public IRequestCycle newRequestCycle(IEngine engine) {
        WebRequest request = this._infrastructure.getRequest();
        QueryParameterMap parameters = this.extractParameters(request);
        this.decodeParameters(request.getActivationPath(), request.getPathInfo(), parameters);
        String serviceName = this.findService(parameters);
        RequestCycle cycle = new RequestCycle(engine, parameters, serviceName, this._environment);
        this._requestGlobals.store(cycle);
        try {
            cycle.setResponseBuilder(this._responseDelegateFactory.getResponseBuilder(cycle));
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Error creating response builder.", (Throwable)e);
        }
        return cycle;
    }

    private String findService(QueryParameterMap parameters) {
        String serviceName = parameters.getParameterValue("service");
        return serviceName == null ? "home" : serviceName;
    }

    private QueryParameterMap extractParameters(WebRequest request) {
        QueryParameterMap result = new QueryParameterMap();
        for (String name : request.getParameterNames()) {
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                result.setParameterValue(name, values[0]);
                continue;
            }
            result.setParameterValues(name, values);
        }
        return result;
    }

    private void decodeParameters(String servletPath, String pathInfo, QueryParameterMap map) {
        ServiceEncodingImpl se = new ServiceEncodingImpl(servletPath, pathInfo, map);
        for (int i = 0; i < this._encoders.length; ++i) {
            this._encoders[i].decode(se);
            if (!se.isModified()) continue;
            return;
        }
    }

    public void setEncoders(ServiceEncoder[] encoders) {
        this._encoders = encoders;
    }

    public void setStrategySource(PropertyPersistenceStrategySource strategySource) {
        this._strategySource = strategySource;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public void setInfrastructure(Infrastructure infrastructure) {
        this._infrastructure = infrastructure;
    }

    public void setAbsoluteURLBuilder(AbsoluteURLBuilder absoluteURLBuilder) {
        this._absoluteURLBuilder = absoluteURLBuilder;
    }

    public void setRequestGlobals(RequestGlobals requestGlobals) {
        this._requestGlobals = requestGlobals;
    }

    public void setResponseDelegateFactory(ResponseDelegateFactory responseDelegate) {
        this._responseDelegateFactory = responseDelegate;
    }

    public ResponseDelegateFactory getResponseDelegateFactory() {
        return this._responseDelegateFactory;
    }
}

