/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.event.ReportStatusEvent;
import org.apache.tapestry.event.ReportStatusListener;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.services.ObjectPool;

public class ObjectPoolImpl
implements ObjectPool,
ResetEventListener,
ReportStatusListener {
    private String _serviceId;
    private int _count = 0;
    private Map _pool = new HashMap();

    public synchronized Object get(Object key) {
        List pooled = (List)this._pool.get(key);
        if (pooled == null || pooled.isEmpty()) {
            return null;
        }
        --this._count;
        return pooled.remove(0);
    }

    public synchronized void store(Object key, Object value) {
        LinkedList<Object> pooled = (LinkedList<Object>)this._pool.get(key);
        if (pooled == null) {
            pooled = new LinkedList<Object>();
            this._pool.put(key, pooled);
        }
        pooled.add(value);
        ++this._count;
    }

    public synchronized void resetEventDidOccur() {
        this._pool.clear();
        this._count = 0;
    }

    public synchronized void reportStatus(ReportStatusEvent event) {
        event.title(this._serviceId);
        event.property("total count", this._count);
        event.section("Count by Key");
        for (Map.Entry entry : this._pool.entrySet()) {
            String key = entry.getKey().toString();
            List pooled = (List)entry.getValue();
            event.property(key, pooled.size());
        }
    }

    public void setServiceId(String serviceId) {
        this._serviceId = serviceId;
    }
}

