/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.List;
import java.util.Map;
import ognl.ClassResolver;
import ognl.NullHandler;
import ognl.Ognl;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.services.ExpressionCache;
import org.apache.tapestry.services.ExpressionEvaluator;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.services.impl.NullHandlerContribution;
import org.apache.tapestry.services.impl.OgnlClassResolver;
import org.apache.tapestry.services.impl.PropertyAccessorContribution;
import org.apache.tapestry.spec.IApplicationSpecification;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private final ClassResolver _ognlResolver = new OgnlClassResolver();
    private ExpressionCache _expressionCache;
    private IApplicationSpecification _applicationSpecification;
    private TypeConverter _typeConverter;
    private List _contributions;
    private List _nullHandlerContributions;
    private Map _defaultContext;

    public void setApplicationSpecification(IApplicationSpecification applicationSpecification) {
        this._applicationSpecification = applicationSpecification;
    }

    public void initializeService() {
        if (this._applicationSpecification.checkExtension("org.apache.tapestry.ognl-type-converter")) {
            this._typeConverter = (TypeConverter)this._applicationSpecification.getExtension("org.apache.tapestry.ognl-type-converter", TypeConverter.class);
        }
        for (PropertyAccessorContribution c : this._contributions) {
            OgnlRuntime.setPropertyAccessor((Class)c.getSubjectClass(), (PropertyAccessor)c.getAccessor());
        }
        for (NullHandlerContribution h : this._nullHandlerContributions) {
            OgnlRuntime.setNullHandler((Class)h.getSubjectClass(), (NullHandler)h.getHandler());
        }
        this._defaultContext = Ognl.createDefaultContext(null, (ClassResolver)this._ognlResolver, (TypeConverter)this._typeConverter);
    }

    public Object read(Object target, String expression) {
        return this.readCompiled(target, this._expressionCache.getCompiledExpression(expression));
    }

    public Object readCompiled(Object target, Object expression) {
        try {
            Map context = this.createContext(target);
            return Ognl.getValue((Object)expression, (Map)context, (Object)target);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToReadExpression(ImplMessages.parsedExpression(), target, ex), target, null, (Throwable)ex);
        }
    }

    private Map createContext(Object target) {
        Map result = Ognl.createDefaultContext((Object)target, (ClassResolver)this._ognlResolver);
        if (this._typeConverter != null) {
            Ognl.setTypeConverter((Map)result, (TypeConverter)this._typeConverter);
        }
        return result;
    }

    public void write(Object target, String expression, Object value) {
        this.writeCompiled(target, this._expressionCache.getCompiledExpression(expression), value);
    }

    public void writeCompiled(Object target, Object expression, Object value) {
        try {
            Map context = this.createContext(target);
            Ognl.setValue((Object)expression, (Map)context, (Object)target, (Object)value);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToWriteExpression(ImplMessages.parsedExpression(), target, value, ex), target, null, (Throwable)ex);
        }
    }

    public boolean isConstant(String expression) {
        Object compiled = this._expressionCache.getCompiledExpression(expression);
        try {
            return Ognl.isConstant((Object)compiled, (Map)this._defaultContext);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.isConstantExpressionError(expression, ex), (Throwable)ex);
        }
    }

    public void setExpressionCache(ExpressionCache expressionCache) {
        this._expressionCache = expressionCache;
    }

    public void setContributions(List contributions) {
        this._contributions = contributions;
    }

    public void setNullHandlerContributions(List nullHandlerContributions) {
        this._nullHandlerContributions = nullHandlerContributions;
    }
}

