/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.Locale;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.services.EngineFactory;
import org.apache.tapestry.services.EngineManager;
import org.apache.tapestry.services.ObjectPool;
import org.apache.tapestry.services.RequestLocaleManager;

public class EngineManagerImpl
implements EngineManager {
    private ObjectPool _enginePool;
    private EngineFactory _engineFactory;
    private RequestLocaleManager _localeManager;

    public IEngine getEngineInstance() {
        Locale locale = this._localeManager.extractLocaleForCurrentRequest();
        IEngine result = (IEngine)this._enginePool.get(locale);
        if (result == null) {
            result = this._engineFactory.constructNewEngineInstance(locale);
        }
        return result;
    }

    public void storeEngineInstance(IEngine engine) {
        this._enginePool.store(engine.getLocale(), engine);
    }

    public void setEngineFactory(EngineFactory factory) {
        this._engineFactory = factory;
    }

    public void setEnginePool(ObjectPool pool) {
        this._enginePool = pool;
    }

    public void setLocaleManager(RequestLocaleManager manager) {
        this._localeManager = manager;
    }
}

