/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.Locale;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorLog;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.engine.BaseEngine;
import org.apache.tapestry.services.EngineFactory;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.spec.IApplicationSpecification;

public class EngineFactoryImpl
implements EngineFactory {
    private IApplicationSpecification _applicationSpecification;
    private String _defaultEngineClassName;
    private EngineConstructor _constructor;
    private ClassResolver _classResolver;
    private ErrorLog _errorLog;

    public void initializeService() {
        Class<BaseEngine> engineClass;
        String engineClassName = this._applicationSpecification.getEngineClassName();
        if (engineClassName == null) {
            engineClassName = this._defaultEngineClassName;
        }
        if ((engineClass = this._classResolver.checkForClass(engineClassName)) == null) {
            this._errorLog.error(ImplMessages.engineClassNotFound(engineClassName), null, null);
            engineClass = BaseEngine.class;
        }
        this._constructor = new ReflectiveEngineConstructor(engineClass);
    }

    public IEngine constructNewEngineInstance(Locale locale) {
        IEngine result = this._constructor.construct();
        result.setLocale(locale);
        return result;
    }

    public void setApplicationSpecification(IApplicationSpecification specification) {
        this._applicationSpecification = specification;
    }

    public void setClassResolver(ClassResolver resolver) {
        this._classResolver = resolver;
    }

    public void setDefaultEngineClassName(String string) {
        this._defaultEngineClassName = string;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    static class ReflectiveEngineConstructor
    implements EngineConstructor {
        private Class _engineClass;

        ReflectiveEngineConstructor(Class engineClass) {
            this._engineClass = engineClass;
        }

        public IEngine construct() {
            try {
                return (IEngine)this._engineClass.newInstance();
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(ImplMessages.errorInstantiatingEngine(this._engineClass, ex), (Throwable)ex);
            }
        }
    }

    static interface EngineConstructor {
        public IEngine construct();
    }
}

