/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.NestedMarkupWriter;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.markup.NestedMarkupWriterImpl;
import org.apache.tapestry.services.RequestLocaleManager;
import org.apache.tapestry.services.ResponseBuilder;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.util.ScriptUtils;
import org.apache.tapestry.web.WebResponse;

public class DojoAjaxResponseBuilder
implements ResponseBuilder {
    private RequestLocaleManager _localeManager;
    private MarkupWriterSource _markupWriterSource;
    private WebResponse _webResponse;
    private List _errorPages;
    private IMarkupWriter _writer;
    private List _parts = new ArrayList();
    private Map _writers = new HashMap();

    public DojoAjaxResponseBuilder(IMarkupWriter writer, List parts) {
        this._writer = writer;
        if (parts != null) {
            this._parts.addAll(parts);
        }
    }

    public DojoAjaxResponseBuilder(RequestLocaleManager localeManager, MarkupWriterSource markupWriterSource, WebResponse webResponse, List errorPages) {
        this._localeManager = localeManager;
        this._markupWriterSource = markupWriterSource;
        this._webResponse = webResponse;
        this._errorPages = errorPages;
    }

    public boolean isDynamic() {
        return Boolean.TRUE;
    }

    public void renderResponse(IRequestCycle cycle) throws IOException {
        this._localeManager.persistLocale();
        ContentType contentType = new ContentType("text/xml;charset=" + cycle.getInfrastructure().getOutputEncoding());
        String encoding = contentType.getParameter("charset");
        if (encoding == null) {
            encoding = cycle.getEngine().getOutputEncoding();
            contentType.setParameter("charset", encoding);
        }
        PrintWriter printWriter = this._webResponse.getPrintWriter(contentType);
        this._writer = this._markupWriterSource.newMarkupWriter(printWriter, contentType);
        this.parseParameters(cycle);
        this.beginResponse();
        cycle.renderPage(this);
        this.endResponse();
        this._writer.close();
    }

    public void updateComponent(String id) {
        if (!this._parts.contains(id)) {
            this._parts.add(id);
        }
    }

    public IMarkupWriter getWriter() {
        return this._writer;
    }

    public boolean isBodyScriptAllowed(IComponent target) {
        if (target != null && IForm.class.isInstance(target) && ((IForm)target).isFormFieldUpdating()) {
            return true;
        }
        return this.contains(target);
    }

    public boolean isExternalScriptAllowed(IComponent target) {
        if (target != null && IForm.class.isInstance(target) && ((IForm)target).isFormFieldUpdating()) {
            return true;
        }
        return this.contains(target);
    }

    public boolean isInitializationScriptAllowed(IComponent target) {
        if (target != null && IForm.class.isInstance(target) && ((IForm)target).isFormFieldUpdating()) {
            return true;
        }
        return this.contains(target);
    }

    public void beginBodyScript(IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter("bodyscript", "script");
        writer.begin("script");
        writer.printRaw("\n//<![CDATA[\n");
    }

    public void endBodyScript(IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter("bodyscript", "script");
        writer.printRaw("\n//]]>\n");
        writer.end();
    }

    public void writeBodyScript(String script, IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter("bodyscript", "script");
        writer.printRaw(script);
    }

    public void writeExternalScript(String url, IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter("includescript", "script");
        writer.printRaw("tapestry.loadScriptFromUrl(\"");
        writer.print(url);
        writer.printRaw("\");");
        writer.println();
    }

    public void writeImageInitializations(String script, String preloadName, IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter("bodyscript", "script");
        writer.printRaw("\n\nvar " + preloadName + " = new Array();\n");
        writer.printRaw("if (document.images)\n");
        writer.printRaw("{\n");
        writer.printRaw(script);
        writer.printRaw("}\n");
    }

    public void writeInitializationScript(String script) {
        IMarkupWriter writer = this.getWriter("initializationscript", "script");
        writer.begin("script");
        writer.printRaw("\n//<![CDATA[\n");
        writer.printRaw(script);
        writer.printRaw("\n//]]>\n");
        writer.end();
    }

    public void render(IMarkupWriter writer, IRender render, IRequestCycle cycle) {
        String errorPage;
        if (NestedMarkupWriterImpl.class.isInstance(writer)) {
            render.render(writer, cycle);
            return;
        }
        if (IPage.class.isInstance(render) && (errorPage = this.getErrorPage(((IPage)render).getPageName())) != null) {
            render.render(this.getWriter(errorPage, "exception"), cycle);
            return;
        }
        if (IComponent.class.isInstance(render) && this.contains((IComponent)render)) {
            render.render(this.getComponentWriter((IComponent)render), cycle);
            return;
        }
        render.render(NullWriter.getSharedInstance(), cycle);
    }

    private String getErrorPage(String pageName) {
        for (int i = 0; i < this._errorPages.size(); ++i) {
            String page = (String)this._errorPages.get(i);
            if (pageName.indexOf(page) <= -1) continue;
            return page;
        }
        return null;
    }

    IMarkupWriter getComponentWriter(IComponent target) {
        String id = this.getComponentId(target);
        return this.getWriter(id, "element");
    }

    public IMarkupWriter getWriter(String id, String type) {
        Defense.notNull((Object)id, (String)"id can't be null");
        IMarkupWriter w = (IMarkupWriter)this._writers.get(id);
        if (w != null) {
            return w;
        }
        NestedMarkupWriter nestedWriter = this._writer.getNestedWriter();
        nestedWriter.begin("response");
        nestedWriter.attribute("id", id);
        if (type != null) {
            nestedWriter.attribute("type", type);
        }
        this._writers.put(id, nestedWriter);
        return nestedWriter;
    }

    void beginResponse() {
        this._writer.printRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this._writer.printRaw("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\" [\n<!ENTITY nbsp '&#160;'>\n]>\n");
        this._writer.printRaw("<ajax-response>");
    }

    void endResponse() {
        for (String key : this._writers.keySet()) {
            NestedMarkupWriter nw = (NestedMarkupWriter)this._writers.get(key);
            nw.end();
            if (!this.isScriptWriter(key)) {
                this._writer.printRaw(ScriptUtils.ensureValidScriptTags(nw.getBuffer()));
                continue;
            }
            this._writer.printRaw(nw.getBuffer());
        }
        this._writer.printRaw("</ajax-response>");
        this._writer.flush();
    }

    boolean isScriptWriter(String key) {
        if (key == null) {
            return false;
        }
        return "bodyscript".equals(key) || "includescript".equals(key) || "initializationscript".equals(key);
    }

    void parseParameters(IRequestCycle cycle) {
        String[] updateParts = cycle.getParameters("updateParts");
        if (updateParts == null) {
            return;
        }
        for (int i = 0; i < updateParts.length; ++i) {
            this._parts.add(updateParts[i].toString());
        }
    }

    boolean contains(IComponent target) {
        if (target == null) {
            return false;
        }
        return this._parts.contains(this.getComponentId(target));
    }

    String getComponentId(IComponent comp) {
        return comp.getClientId();
    }
}

