/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.services.RequestLocaleManager;
import org.apache.tapestry.services.ResponseBuilder;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.web.WebResponse;

public class DefaultResponseBuilder
implements ResponseBuilder {
    private RequestLocaleManager _localeManager;
    private MarkupWriterSource _markupWriterSource;
    private WebResponse _webResponse;
    private IMarkupWriter _writer;

    public DefaultResponseBuilder(IMarkupWriter writer) {
        this._writer = writer;
    }

    public DefaultResponseBuilder(RequestLocaleManager localeManager, MarkupWriterSource markupWriterSource, WebResponse webResponse) {
        this._localeManager = localeManager;
        this._markupWriterSource = markupWriterSource;
        this._webResponse = webResponse;
    }

    public boolean isDynamic() {
        return Boolean.FALSE;
    }

    public void renderResponse(IRequestCycle cycle) throws IOException {
        if (this._writer == null) {
            this._localeManager.persistLocale();
            IPage page = cycle.getPage();
            ContentType contentType = page.getResponseContentType();
            String encoding = contentType.getParameter("charset");
            if (encoding == null) {
                encoding = cycle.getEngine().getOutputEncoding();
                contentType.setParameter("charset", encoding);
            }
            PrintWriter printWriter = this._webResponse.getPrintWriter(contentType);
            this._writer = this._markupWriterSource.newMarkupWriter(printWriter, contentType);
        }
        cycle.renderPage(this);
        this._writer.close();
    }

    public void render(IMarkupWriter writer, IRender render, IRequestCycle cycle) {
        if (writer == null) {
            render.render(this._writer, cycle);
        } else {
            render.render(writer, cycle);
        }
    }

    public void updateComponent(String id) {
    }

    public IMarkupWriter getWriter() {
        if (this._writer == null) {
            return NullWriter.getSharedInstance();
        }
        return this._writer;
    }

    public IMarkupWriter getWriter(String id, String type) {
        if (this._writer == null) {
            return NullWriter.getSharedInstance();
        }
        return this._writer;
    }

    public boolean isBodyScriptAllowed(IComponent target) {
        return true;
    }

    public boolean isExternalScriptAllowed(IComponent target) {
        return true;
    }

    public boolean isInitializationScriptAllowed(IComponent target) {
        return true;
    }

    public void beginBodyScript(IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter();
        writer.begin("script");
        writer.attribute("type", "text/javascript");
        writer.printRaw("<!--");
    }

    public void endBodyScript(IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter();
        writer.printRaw("\n\n// -->");
        writer.end();
    }

    public void writeBodyScript(String script, IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter();
        writer.printRaw("\n\n");
        writer.printRaw(script);
    }

    public void writeExternalScript(String url, IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter();
        writer.begin("script");
        writer.attribute("type", "text/javascript");
        writer.attribute("src", url);
        writer.end();
        writer.println();
    }

    public void writeImageInitializations(String script, String preloadName, IRequestCycle cycle) {
        IMarkupWriter writer = this.getWriter();
        writer.printRaw("\n\nvar " + preloadName + " = new Array();\n");
        writer.printRaw("if (document.images)\n");
        writer.printRaw("{\n");
        writer.printRaw(script);
        writer.printRaw("}\n");
    }

    public void writeInitializationScript(String script) {
        IMarkupWriter writer = this.getWriter();
        writer.begin("script");
        writer.attribute("type", "text/javascript");
        writer.printRaw("<!--\n");
        writer.printRaw("dojo.event.connect(window, 'onload', function(e) {\n");
        writer.printRaw(script);
        writer.printRaw("});");
        writer.printRaw("\n// -->");
        writer.end();
    }
}

