/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.ITemplateComponent;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.binding.BindingSource;
import org.apache.tapestry.binding.LiteralBinding;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.parse.CloseToken;
import org.apache.tapestry.parse.ComponentTemplate;
import org.apache.tapestry.parse.LocalizationToken;
import org.apache.tapestry.parse.OpenToken;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TextToken;
import org.apache.tapestry.parse.TokenType;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.services.impl.LocalizedStringRender;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.spec.IParameterSpecification;

public class ComponentTemplateLoaderLogic {
    private Log _log;
    private IPageLoader _pageLoader;
    private IRequestCycle _requestCycle;
    private ITemplateComponent _loadComponent;
    private BindingSource _bindingSource;
    private IComponent[] _stack;
    private int _stackx;
    private IComponent _activeComponent = null;
    private Set _seenIds = new HashSet();

    public ComponentTemplateLoaderLogic(Log log, IPageLoader pageLoader, BindingSource bindingSource) {
        this._log = log;
        this._pageLoader = pageLoader;
        this._bindingSource = bindingSource;
    }

    public void loadTemplate(IRequestCycle requestCycle, ITemplateComponent loadComponent, ComponentTemplate template) {
        this._requestCycle = requestCycle;
        this._loadComponent = loadComponent;
        this.process(template);
    }

    private void process(ComponentTemplate template) {
        int count = template.getTokenCount();
        this._stack = new IComponent[count];
        for (int i = 0; i < count; ++i) {
            TemplateToken token = template.getToken(i);
            TokenType type = token.getType();
            if (type == TokenType.TEXT) {
                this.process((TextToken)token);
                continue;
            }
            if (type == TokenType.OPEN) {
                this.process((OpenToken)token);
                continue;
            }
            if (type == TokenType.CLOSE) {
                this.process((CloseToken)token);
                continue;
            }
            if (type != TokenType.LOCALIZATION) continue;
            this.process((LocalizationToken)token);
        }
        if (this._stackx != 0) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("BaseComponent.unbalance-open-tags"), (Object)this._loadComponent, null, null);
        }
        this.checkAllComponentsReferenced();
    }

    private void process(TextToken token) {
        if (this._activeComponent == null) {
            this._loadComponent.addOuter(token);
            return;
        }
        if (!this._activeComponent.getSpecification().getAllowBody()) {
            throw this.createBodylessComponentException(this._activeComponent);
        }
        this._activeComponent.addBody(token);
    }

    private void process(OpenToken token) {
        String id = token.getId();
        IComponent component = null;
        String componentType = token.getComponentType();
        if (componentType == null) {
            component = this.getEmbeddedComponent(id);
        } else {
            this.checkForDuplicateId(id, token.getLocation());
            component = this.createImplicitComponent(id, componentType, token.getLocation());
        }
        if (this._seenIds.contains(id)) {
            throw new ApplicationRuntimeException(ImplMessages.multipleComponentReferences(this._loadComponent, id), (Object)this._loadComponent, token.getLocation(), null);
        }
        this._seenIds.add(id);
        if (this._activeComponent == null) {
            this._loadComponent.addOuter(component);
        } else {
            if (!this._activeComponent.getSpecification().getAllowBody()) {
                throw this.createBodylessComponentException(this._activeComponent);
            }
            this._activeComponent.addBody(component);
        }
        this.addTemplateBindings(component, token);
        this._stack[this._stackx++] = this._activeComponent;
        this._activeComponent = component;
    }

    private void checkForDuplicateId(String id, Location location) {
        if (id == null) {
            return;
        }
        IContainedComponent cc = this._loadComponent.getSpecification().getComponent(id);
        if (cc != null) {
            throw new ApplicationRuntimeException(ImplMessages.dupeComponentId(id, cc), (Object)this._loadComponent, location, null);
        }
    }

    private IComponent createImplicitComponent(String id, String componentType, Location location) {
        IComponent result = this._pageLoader.createImplicitComponent(this._requestCycle, this._loadComponent, id, componentType, location);
        return result;
    }

    private IComponent getEmbeddedComponent(String id) {
        return this._loadComponent.getComponent(id);
    }

    private void process(CloseToken token) {
        if (this._stackx <= 0) {
            throw new ApplicationRuntimeException(ImplMessages.unbalancedCloseTags(), (Object)this._loadComponent, token.getLocation(), null);
        }
        this._stack[this._stackx--] = null;
        this._activeComponent = this._stack[this._stackx];
    }

    private void process(LocalizationToken token) {
        LocalizedStringRender render = new LocalizedStringRender(this._loadComponent, token);
        if (this._activeComponent == null) {
            this._loadComponent.addOuter(render);
        } else {
            this._activeComponent.addBody(render);
        }
    }

    void addTemplateBindings(IComponent component, OpenToken token) {
        IComponentSpecification spec = component.getSpecification();
        Map attributes = token.getAttributesMap();
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String parameterName;
                String attributeName = (String)entry.getKey();
                String value = (String)entry.getValue();
                IParameterSpecification pspec = spec.getParameter(attributeName);
                String string = parameterName = pspec == null ? attributeName : pspec.getParameterName();
                if (!attributeName.equals(parameterName)) {
                    this._log.warn((Object)ImplMessages.usedTemplateParameterAlias(token, attributeName, parameterName));
                }
                String description = ImplMessages.templateParameterName(parameterName);
                IBinding binding = this._bindingSource.createBinding(this._loadComponent, description, value, "literal", token.getLocation());
                this.addBinding(component, spec, parameterName, binding);
            }
        }
        if (spec.getParameter("templateTag") != null && component.getBinding("templateTag") == null) {
            IBinding binding = this._bindingSource.createBinding(component, "templateTag", token.getTag(), "literal", token.getLocation());
            this.addBinding(component, spec, "templateTag", binding);
        }
    }

    private void addBinding(IComponent component, IComponentSpecification spec, String name, IBinding binding) {
        boolean valid = this.validate(component, spec, name, binding);
        if (valid) {
            component.setBinding(name, binding);
        }
    }

    private boolean validate(IComponent component, IComponentSpecification spec, String name, IBinding binding) {
        boolean isFormal;
        boolean isLiteral = binding instanceof LiteralBinding;
        boolean isBound = component.getBinding(name) != null;
        boolean bl = isFormal = spec.getParameter(name) != null;
        if (!isFormal) {
            if (!spec.getAllowInformalParameters()) {
                if (isLiteral) {
                    return false;
                }
                throw new ApplicationRuntimeException(ImplMessages.templateBindingForInformalParameter(this._loadComponent, name, component), (Object)component, binding.getLocation(), null);
            }
            if (spec.isReservedParameterName(name)) {
                if (isLiteral) {
                    return false;
                }
                throw new ApplicationRuntimeException(ImplMessages.templateBindingForReservedParameter(this._loadComponent, name, component), (Object)component, binding.getLocation(), null);
            }
        }
        if (isBound) {
            if (isLiteral) {
                return false;
            }
            throw new ApplicationRuntimeException(ImplMessages.dupeTemplateBinding(name, component, this._loadComponent), (Object)component, binding.getLocation(), null);
        }
        return true;
    }

    private void checkAllComponentsReferenced() {
        Map components = this._loadComponent.getComponents();
        Set ids = components.keySet();
        if (this._seenIds.containsAll(ids)) {
            return;
        }
        ids = new HashSet(ids);
        ids.removeAll(this._seenIds);
        this._log.warn((Object)ImplMessages.missingComponentSpec(this._loadComponent, ids));
    }

    private ApplicationRuntimeException createBodylessComponentException(IComponent component) {
        return new ApplicationRuntimeException(ImplMessages.bodylessComponent(), (Object)component, null, null);
    }
}

