/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.BrowserEvent;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.form.FormSupport;
import org.apache.tapestry.internal.event.ComponentEventProperty;
import org.apache.tapestry.internal.event.EventBoundListener;
import org.apache.tapestry.listener.ListenerInvoker;

public class ComponentEventInvoker
implements ResetEventListener {
    private Map _components = new HashMap();
    private Map _elements = new HashMap();
    private ListenerInvoker _invoker;

    public void invokeListeners(IComponent component, IRequestCycle cycle, BrowserEvent event) {
        String targetId;
        Defense.notNull((Object)component, (String)"component");
        Defense.notNull((Object)cycle, (String)"cycle");
        Defense.notNull((Object)event, (String)"event");
        String id = component.getId();
        if (this.hasEvents(id)) {
            ComponentEventProperty prop = this.getComponentEvents(id);
            this.invokeListeners(prop, component, cycle, event);
        }
        if (this.hasElementEvents(targetId = (String)event.getTarget().get("id"))) {
            ComponentEventProperty prop = this.getElementEvents(id);
            this.invokeListeners(prop, component, cycle, event);
        }
    }

    void invokeListeners(ComponentEventProperty prop, IComponent component, IRequestCycle cycle, BrowserEvent event) {
        List listeners = prop.getEventListeners(event.getName());
        for (int i = 0; i < listeners.size(); ++i) {
            EventBoundListener eventListener = (EventBoundListener)listeners.get(i);
            IComponent container = component.getContainer();
            if (container == null) {
                container = component;
            }
            IActionListener listener = container.getListeners().getListener(eventListener.getMethodName());
            this._invoker.invokeListener(listener, container, cycle);
        }
    }

    public void invokeFormListeners(FormSupport formSupport, final IRequestCycle cycle, BrowserEvent event) {
        IForm component = formSupport.getForm();
        String id = component.getId();
        List listeners = this.getFormEvents(id, event);
        for (int i = 0; i < listeners.size(); ++i) {
            EventBoundListener eventListener = (EventBoundListener)listeners.get(i);
            final IComponent container = component.getContainer() == null ? component : component.getContainer();
            final IActionListener listener = container.getListeners().getListener(eventListener.getMethodName());
            component.addDeferredRunnable(new Runnable(){

                public void run() {
                    ComponentEventInvoker.this._invoker.invokeListener(listener, container, cycle);
                }
            });
        }
    }

    public void addEventListener(String componentId, String[] events, String methodName, String formId, boolean validateForm, boolean async) {
        ComponentEventProperty property = this.getComponentEvents(componentId);
        property.addListener(events, methodName, formId, validateForm, async);
    }

    public void addElementEventListener(String elementId, String[] events, String methodName, String formId, boolean validateForm, boolean async) {
        ComponentEventProperty property = this.getElementEvents(elementId);
        property.addListener(events, methodName, formId, validateForm, async);
    }

    public boolean hasEvents(String componentId) {
        return this._components.get(componentId) != null;
    }

    public boolean hasElementEvents() {
        return this._elements.size() > 0;
    }

    public boolean hasElementEvents(String id) {
        return this._elements.get(id) != null;
    }

    public ComponentEventProperty getComponentEvents(String id) {
        ComponentEventProperty prop = (ComponentEventProperty)this._components.get(id);
        if (prop == null) {
            prop = new ComponentEventProperty(id);
            this._components.put(id, prop);
        }
        return prop;
    }

    List getFormEvents(String id, BrowserEvent event) {
        ArrayList ret = new ArrayList();
        for (ComponentEventProperty prop : this._components.values()) {
            prop.getFormEventListeners(id, event, ret);
        }
        for (ComponentEventProperty prop : this._elements.values()) {
            prop.getFormEventListeners(id, event, ret);
        }
        return ret;
    }

    public ComponentEventProperty getElementEvents(String id) {
        ComponentEventProperty prop = (ComponentEventProperty)this._elements.get(id);
        if (prop == null) {
            prop = new ComponentEventProperty(id);
            this._elements.put(id, prop);
        }
        return prop;
    }

    public Map getElementEvents() {
        return this._elements;
    }

    public void resetEventDidOccur() {
        this._components.clear();
        this._elements.clear();
    }

    public void setListenerInvoker(ListenerInvoker invoker) {
        this._invoker = invoker;
    }
}

