/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirectEvent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.dojo.IWidget;
import org.apache.tapestry.engine.DirectEventServiceParameter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.internal.event.ComponentEventProperty;
import org.apache.tapestry.internal.event.EventBoundListener;
import org.apache.tapestry.services.ComponentRenderWorker;
import org.apache.tapestry.services.impl.ComponentEventInvoker;

public class ComponentEventConnectionWorker
implements ComponentRenderWorker {
    public static final String FORM_NAME_LIST = "org.apache.tapestry.services.impl.ComponentEventConnectionFormNames-";
    private ComponentEventInvoker _invoker;
    private IEngineService _eventEngine;
    private IScriptSource _scriptSource;
    private String _componentScript;
    private String _widgetScript;
    private String _elementScript;
    private ClassResolver _resolver;
    private ClasspathResource _componentResource;
    private ClasspathResource _widgetResource;
    private ClasspathResource _elementResource;
    private Map _deferredFormConnections = new HashMap();

    public void renderComponent(IRequestCycle cycle, IComponent component) {
        if (cycle.isRewinding() || TapestryUtils.getOptionalPageRenderSupport(cycle) == null) {
            return;
        }
        IComponent field = (IComponent)cycle.getAttribute("org.apache.tapestry.form.Prerender");
        if (field != null && field == component) {
            return;
        }
        if (this._invoker.hasEvents(component.getId())) {
            this.linkComponent(cycle, component);
        }
        if (IForm.class.isInstance(component)) {
            this.mapFormNames(cycle, (IForm)component);
        }
        if (this.isDeferredForm(component)) {
            this.linkDeferredForm(cycle, (IForm)component);
        }
    }

    void linkComponent(IRequestCycle cycle, IComponent component) {
        ComponentEventProperty prop = this._invoker.getComponentEvents(component.getId());
        String clientId = component.getClientId();
        HashMap<String, Object> parms = new HashMap<String, Object>();
        parms.put("clientId", clientId);
        parms.put("component", component);
        Set events = prop.getEvents();
        Object[][] formEvents = this.filterFormEvents(prop, parms, cycle);
        if (events.size() < 1 && formEvents.length < 1) {
            return;
        }
        DirectEventServiceParameter dsp = new DirectEventServiceParameter((IDirectEvent)component, new Object[0], new String[0], false);
        parms.put("url", this._eventEngine.getLink(false, dsp).getURL());
        parms.put("events", events);
        parms.put("formEvents", formEvents);
        PageRenderSupport prs = TapestryUtils.getPageRenderSupport(cycle, component);
        Resource resource = this.getScript(component);
        this._scriptSource.getScript(resource).execute(cycle, prs, parms);
    }

    public void renderBody(IRequestCycle cycle, Body component) {
        if (cycle.isRewinding() || !this._invoker.hasElementEvents()) {
            return;
        }
        HashMap<String, Object> parms = new HashMap<String, Object>();
        DirectEventServiceParameter dsp = new DirectEventServiceParameter(component, new Object[0], new String[0], false);
        String url = this._eventEngine.getLink(false, dsp).getURL();
        PageRenderSupport prs = TapestryUtils.getPageRenderSupport(cycle, component);
        Resource resource = this.getScript(component);
        Map elements = this._invoker.getElementEvents();
        for (String target : elements.keySet()) {
            ComponentEventProperty prop = (ComponentEventProperty)elements.get(target);
            parms.put("target", target);
            parms.put("url", url);
            parms.put("events", prop.getEvents());
            parms.put("formEvents", this.filterFormEvents(prop, parms, cycle));
            this._scriptSource.getScript(resource).execute(cycle, prs, parms);
            parms.clear();
        }
        this._deferredFormConnections.clear();
    }

    void mapFormNames(IRequestCycle cycle, IForm form) {
        ArrayList<String> names = (ArrayList<String>)cycle.getAttribute(FORM_NAME_LIST + form.getId());
        if (names == null) {
            names = new ArrayList<String>();
            cycle.setAttribute(FORM_NAME_LIST + form.getId(), names);
        }
        names.add(form.getName());
    }

    void linkDeferredForm(IRequestCycle cycle, IForm form) {
        List deferred = (List)this._deferredFormConnections.remove(form.getId());
        for (int i = 0; i < deferred.size(); ++i) {
            Object[] val = (Object[])deferred.get(i);
            Map scriptParms = (Map)val[0];
            IComponent component = (IComponent)scriptParms.get("component");
            ComponentEventProperty props = this._invoker.getComponentEvents(component.getId());
            Object[][] formEvents = this.buildFormEvents(cycle, form.getId(), props.getFormEvents(), (Boolean)val[1]);
            scriptParms.remove("events");
            scriptParms.put("formEvents", formEvents);
            PageRenderSupport prs = TapestryUtils.getPageRenderSupport(cycle, component);
            Resource resource = this.getScript(component);
            this._scriptSource.getScript(resource).execute(cycle, prs, scriptParms);
        }
    }

    Object[][] buildFormEvents(IRequestCycle cycle, String formId, Set events, Boolean async) {
        List formNames = (List)cycle.getAttribute(FORM_NAME_LIST + formId);
        ArrayList<Object[]> retval = new ArrayList<Object[]>();
        for (String event : events) {
            retval.add(new Object[]{event, formNames, async});
        }
        return (Object[][])retval.toArray((T[])new Object[retval.size()][3]);
    }

    Resource getScript(IComponent component) {
        if (IWidget.class.isInstance(component)) {
            if (this._widgetResource == null) {
                this._widgetResource = new ClasspathResource(this._resolver, this._widgetScript);
            }
            return this._widgetResource;
        }
        if (Body.class.isInstance(component)) {
            if (this._elementResource == null) {
                this._elementResource = new ClasspathResource(this._resolver, this._elementScript);
            }
            return this._elementResource;
        }
        if (this._componentResource == null) {
            this._componentResource = new ClasspathResource(this._resolver, this._componentScript);
        }
        return this._componentResource;
    }

    boolean isDeferredForm(IComponent component) {
        return IForm.class.isInstance(component) && this._deferredFormConnections.get(((IForm)component).getId()) != null;
    }

    Object[][] filterFormEvents(ComponentEventProperty prop, Map scriptParms, IRequestCycle cycle) {
        Set events = prop.getFormEvents();
        if (events.size() < 1) {
            return new Object[0][0];
        }
        ArrayList<Object[]> retval = new ArrayList<Object[]>();
        for (String event : events) {
            for (EventBoundListener listener : prop.getFormEventListeners(event)) {
                String formId = listener.getFormId();
                List formNames = (List)cycle.getAttribute(FORM_NAME_LIST + formId);
                if (formNames == null) {
                    this.deferFormConnection(formId, scriptParms, listener.isAsync());
                    continue;
                }
                retval.add(new Object[]{event, formNames, listener.isAsync()});
            }
        }
        return (Object[][])retval.toArray((T[])new Object[retval.size()][3]);
    }

    void deferFormConnection(String formId, Map scriptParms, boolean async) {
        ArrayList<Object[]> deferred = (ArrayList<Object[]>)this._deferredFormConnections.get(formId);
        if (deferred == null) {
            deferred = new ArrayList<Object[]>();
            this._deferredFormConnections.put(formId, deferred);
        }
        deferred.add(new Object[]{scriptParms, async});
    }

    Map getDefferedFormConnections() {
        return this._deferredFormConnections;
    }

    public void setComponentEventInvoker(ComponentEventInvoker invoker) {
        this._invoker = invoker;
    }

    public void setEventEngine(IEngineService eventEngine) {
        this._eventEngine = eventEngine;
    }

    public void setComponentScript(String script) {
        this._componentScript = script;
    }

    public void setWidgetScript(String script) {
        this._widgetScript = script;
    }

    public void setElementScript(String script) {
        this._elementScript = script;
    }

    public void setScriptSource(IScriptSource scriptSource) {
        this._scriptSource = scriptSource;
    }

    public void setClassResolver(ClassResolver resolver) {
        this._resolver = resolver;
    }
}

