/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.engine.ServiceEncoding;
import org.apache.tapestry.record.PropertyPersistenceStrategy;
import org.apache.tapestry.record.PropertyPersistenceStrategyContribution;
import org.apache.tapestry.record.PropertyPersistenceStrategySource;
import org.apache.tapestry.record.RecordMessages;

public class PropertyPersistenceStrategySourceImpl
implements PropertyPersistenceStrategySource {
    private List _contributions;
    private Map _strategies = new HashMap();

    public void initializeService() {
        for (PropertyPersistenceStrategyContribution c : this._contributions) {
            this._strategies.put(c.getName(), c.getStrategy());
        }
    }

    public PropertyPersistenceStrategy getStrategy(String name) {
        if (!this._strategies.containsKey(name)) {
            throw new ApplicationRuntimeException(RecordMessages.unknownPersistenceStrategy(name));
        }
        return (PropertyPersistenceStrategy)this._strategies.get(name);
    }

    public Collection getAllStoredChanges(String pageName) {
        ArrayList result = new ArrayList();
        for (PropertyPersistenceStrategy s : this._strategies.values()) {
            result.addAll(s.getStoredChanges(pageName));
        }
        return result;
    }

    public void discardAllStoredChanged(String pageName) {
        for (PropertyPersistenceStrategy s : this._strategies.values()) {
            s.discardStoredChanges(pageName);
        }
    }

    public void addParametersForPersistentProperties(ServiceEncoding encoding, boolean post) {
        for (PropertyPersistenceStrategy s : this._strategies.values()) {
            s.addParametersForPersistentProperties(encoding, post);
        }
    }

    public void setContributions(List contributions) {
        this._contributions = contributions;
    }
}

