/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.record.ChangeKey;
import org.apache.tapestry.record.PersistentPropertyDataEncoder;
import org.apache.tapestry.record.PropertyChange;
import org.apache.tapestry.record.PropertyChangeImpl;

public class PersistentPropertyData {
    private Map _changes;
    private String _encoded;
    private final PersistentPropertyDataEncoder _encoder;

    public PersistentPropertyData(PersistentPropertyDataEncoder encoder) {
        Defense.notNull((Object)encoder, (String)"encoder");
        this._encoder = encoder;
        this._changes = new HashMap();
    }

    public String getEncoded() {
        if (this._encoded == null) {
            this._encoded = this.encode();
        }
        return this._encoded;
    }

    public List getPageChanges() {
        if (this._changes == null) {
            List pageChanges = this._encoder.decodePageChanges(this._encoded);
            this._changes = this.decode(pageChanges);
            return pageChanges;
        }
        return this.createPageChangeList();
    }

    public void store(String componentPath, String propertyName, Object newValue) {
        Defense.notNull((Object)propertyName, (String)"propertyName");
        if (this._changes == null) {
            this._changes = this.decode(this._encoder.decodePageChanges(this._encoded));
        }
        ChangeKey key = new ChangeKey(componentPath, propertyName);
        this._changes.put(key, newValue);
        this._encoded = null;
    }

    public void storeEncoded(String encoded) {
        Defense.notNull((Object)encoded, (String)"encoded");
        this._encoded = encoded;
        this._changes = null;
    }

    private List createPageChangeList() {
        ArrayList<PropertyChangeImpl> result = new ArrayList<PropertyChangeImpl>();
        for (Map.Entry me : this._changes.entrySet()) {
            ChangeKey changeKey = (ChangeKey)me.getKey();
            Object value = me.getValue();
            PropertyChangeImpl change = new PropertyChangeImpl(changeKey.getComponentPath(), changeKey.getPropertyName(), value);
            result.add(change);
        }
        return result;
    }

    private String encode() {
        List changes = this.createPageChangeList();
        return this._encoder.encodePageChanges(changes);
    }

    private Map decode(List pageChanges) {
        HashMap<ChangeKey, Object> result = new HashMap<ChangeKey, Object>();
        for (PropertyChange pc : pageChanges) {
            String propertyName = pc.getPropertyName();
            String componentPath = pc.getComponentPath();
            ChangeKey key = new ChangeKey(componentPath, propertyName);
            result.put(key, pc.getNewValue());
        }
        return result;
    }
}

