/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.LocationImpl;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.tapestry.parse.ITemplateParser;
import org.apache.tapestry.parse.ITemplateParserDelegate;
import org.apache.tapestry.parse.LocalizationToken;
import org.apache.tapestry.parse.OpenToken;
import org.apache.tapestry.parse.ParseMessages;
import org.apache.tapestry.parse.TemplateParseException;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TemplateTokenFactory;
import org.apache.tapestry.parse.TextToken;
import org.apache.tapestry.util.IdAllocator;

public class TemplateParser
implements ITemplateParser {
    public static final String LOCALIZATION_KEY_ATTRIBUTE_NAME = "key";
    public static final String RAW_ATTRIBUTE_NAME = "raw";
    public static final String PROPERTY_NAME_PATTERN = "_?[a-zA-Z]\\w*";
    public static final String SIMPLE_ID_PATTERN = "^(_?[a-zA-Z]\\w*)$";
    public static final String IMPLICIT_ID_PATTERN = "^(_?[a-zA-Z]\\w*)?@(((_?[a-zA-Z]\\w*):)?((_?[a-zA-Z]\\w*/)*_?[a-zA-Z]\\w*))$";
    private static final String REMOVE_ID = "$remove$";
    private static final String CONTENT_ID = "$content$";
    private static final int IMPLICIT_ID_PATTERN_ID_GROUP = 1;
    private static final int IMPLICIT_ID_PATTERN_TYPE_GROUP = 2;
    private static final int IMPLICIT_ID_PATTERN_LIBRARY_ID_GROUP = 4;
    private static final int IMPLICIT_ID_PATTERN_SIMPLE_TYPE_GROUP = 5;
    private static final char[] COMMENT_START = new char[]{'<', '!', '-', '-'};
    private static final char[] COMMENT_END = new char[]{'-', '-', '>'};
    private static final char[] CLOSE_TAG = new char[]{'<', '/'};
    private static final int WAIT_FOR_ATTRIBUTE_NAME = 0;
    private static final int COLLECT_ATTRIBUTE_NAME = 1;
    private static final int ADVANCE_PAST_EQUALS = 2;
    private static final int WAIT_FOR_ATTRIBUTE_VALUE = 3;
    private static final int COLLECT_QUOTED_VALUE = 4;
    private static final int COLLECT_UNQUOTED_VALUE = 5;
    private static final String[] CONVERSIONS = new String[]{"&lt;", "<", "&gt;", ">", "&quot;", "\"", "&amp;", "&"};
    private String _componentAttributeName;
    private Pattern _simpleIdPattern;
    private Pattern _implicitIdPattern;
    private PatternMatcher _patternMatcher;
    private IdAllocator _idAllocator = new IdAllocator();
    private ITemplateParserDelegate _delegate;
    private Resource _resourceLocation;
    private Location _templateLocation;
    private Location _currentLocation;
    private char[] _templateData;
    private List _stack = new ArrayList();
    private List _tokens = new ArrayList();
    private int _cursor;
    private int _blockStart;
    private int _line;
    private boolean _ignoring;
    private Map _attributes = new HashMap();
    private TemplateTokenFactory _factory;

    public TemplateParser() {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this._simpleIdPattern = compiler.compile(SIMPLE_ID_PATTERN);
            this._implicitIdPattern = compiler.compile(IMPLICIT_ID_PATTERN);
        }
        catch (MalformedPatternException ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
        this._patternMatcher = new Perl5Matcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateToken[] parse(char[] templateData, ITemplateParserDelegate delegate, Resource resourceLocation) throws TemplateParseException {
        try {
            this.beforeParse(templateData, delegate, resourceLocation);
            this.parse();
            TemplateToken[] templateTokenArray = this._tokens.toArray(new TemplateToken[this._tokens.size()]);
            return templateTokenArray;
        }
        finally {
            this.afterParse();
        }
    }

    protected void beforeParse(char[] templateData, ITemplateParserDelegate delegate, Resource resourceLocation) {
        this._templateData = templateData;
        this._resourceLocation = resourceLocation;
        this._templateLocation = new LocationImpl(resourceLocation);
        this._delegate = delegate;
        this._ignoring = false;
        this._line = 1;
        this._componentAttributeName = delegate.getComponentAttributeName();
    }

    protected void afterParse() {
        this._delegate = null;
        this._templateData = null;
        this._resourceLocation = null;
        this._templateLocation = null;
        this._currentLocation = null;
        this._stack.clear();
        this._tokens.clear();
        this._attributes.clear();
        this._idAllocator.clear();
    }

    protected void templateParseProblem(String message, Location location, int line, int cursor) throws TemplateParseException {
        throw new TemplateParseException(message, location);
    }

    protected void templateParseProblem(ApplicationRuntimeException exception, int line, int cursor) {
        throw exception;
    }

    protected List getTokens() {
        if (this._tokens == null) {
            return Collections.EMPTY_LIST;
        }
        return this._tokens;
    }

    private boolean lookahead(char[] match) {
        try {
            for (int i = 0; i < match.length; ++i) {
                if (this._templateData[this._cursor + i] == match[i]) continue;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    protected void parse() throws TemplateParseException {
        this._cursor = 0;
        this._blockStart = -1;
        int length = this._templateData.length;
        while (this._cursor < length) {
            if (this._templateData[this._cursor] != '<') {
                if (this._blockStart < 0 && !this._ignoring) {
                    this._blockStart = this._cursor;
                }
                this.advance();
                continue;
            }
            if (this.lookahead(CLOSE_TAG)) {
                this.closeTag();
                continue;
            }
            if (this.lookahead(COMMENT_START)) {
                this.skipComment();
                continue;
            }
            this.startTag();
        }
        this.addTextToken(this._templateData.length - 1);
    }

    private void skipComment() throws TemplateParseException {
        int length = this._templateData.length;
        int startLine = this._line;
        if (this._blockStart < 0 && !this._ignoring) {
            this._blockStart = this._cursor;
        }
        while (true) {
            if (this._cursor >= length) {
                this.templateParseProblem(ParseMessages.commentNotEnded(startLine), (Location)new LocationImpl(this._resourceLocation, startLine), startLine, this._cursor);
            }
            if (this.lookahead(COMMENT_END)) break;
            this.advance();
        }
        this._cursor += COMMENT_END.length;
        this.advanceOverWhitespace();
    }

    private void addTextToken(int end) {
        if (this._blockStart < 0) {
            return;
        }
        if (this._blockStart <= end) {
            TextToken token = this._factory.createTextToken(this._templateData, this._blockStart, end, this._templateLocation);
            this._tokens.add(token);
        }
        this._blockStart = -1;
    }

    private void startTag() throws TemplateParseException {
        int cursorStart = this._cursor;
        int length = this._templateData.length;
        String tagName = null;
        boolean endOfTag = false;
        boolean emptyTag = false;
        int startLine = this._line;
        LocationImpl startLocation = new LocationImpl(this._resourceLocation, startLine);
        this.tagBeginEvent(startLine, this._cursor);
        this.advance();
        while (this._cursor < length) {
            char ch = this._templateData[this._cursor];
            if (ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                tagName = new String(this._templateData, cursorStart + 1, this._cursor - cursorStart - 1);
                break;
            }
            this.advance();
        }
        String attributeName = null;
        int attributeNameStart = -1;
        int attributeValueStart = -1;
        int state = 0;
        char quoteChar = '\u0000';
        this._attributes.clear();
        while (!endOfTag) {
            if (this._cursor >= length) {
                String message = tagName == null ? ParseMessages.unclosedUnknownTag(startLine) : ParseMessages.unclosedTag(tagName, startLine);
                this.templateParseProblem(message, (Location)startLocation, startLine, cursorStart);
            }
            char ch = this._templateData[this._cursor];
            switch (state) {
                case 0: {
                    if (ch == '/') {
                        emptyTag = true;
                        this.advance();
                        break;
                    }
                    if (ch == '>') {
                        endOfTag = true;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    attributeNameStart = this._cursor;
                    state = 1;
                    this.advance();
                    break;
                }
                case 1: {
                    if (ch == '=' || ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                        attributeName = new String(this._templateData, attributeNameStart, this._cursor - attributeNameStart);
                        state = 2;
                        break;
                    }
                    this.advance();
                    break;
                }
                case 2: {
                    if (ch == '/' || ch == '>') {
                        state = 0;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    if (ch == '=') {
                        state = 3;
                        quoteChar = '\u0000';
                        attributeValueStart = -1;
                        this.advance();
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    if (ch == '/' || ch == '>') {
                        this.templateParseProblem(ParseMessages.missingAttributeValue(tagName, this._line, attributeName), this.getCurrentLocation(), this._line, this._cursor);
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    if (ch == '\'' || ch == '\"') {
                        quoteChar = ch;
                        state = 4;
                        this.advance();
                        attributeValueStart = this._cursor;
                        this.attributeBeginEvent(attributeName, this._line, attributeValueStart);
                        break;
                    }
                    state = 5;
                    attributeValueStart = this._cursor;
                    this.attributeBeginEvent(attributeName, this._line, attributeValueStart);
                    break;
                }
                case 4: {
                    String attributeValue;
                    if (ch == quoteChar) {
                        attributeValue = new String(this._templateData, attributeValueStart, this._cursor - attributeValueStart);
                        this.attributeEndEvent(this._cursor);
                        this.addAttributeIfUnique(tagName, attributeName, attributeValue);
                        this.advance();
                        state = 0;
                        break;
                    }
                    this.advance();
                    break;
                }
                case 5: {
                    String attributeValue;
                    if (ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                        attributeValue = new String(this._templateData, attributeValueStart, this._cursor - attributeValueStart);
                        this.attributeEndEvent(this._cursor);
                        this.addAttributeIfUnique(tagName, attributeName, attributeValue);
                        state = 0;
                        break;
                    }
                    this.advance();
                }
            }
        }
        this.tagEndEvent(this._cursor);
        String localizationKey = this.findValueCaselessly(LOCALIZATION_KEY_ATTRIBUTE_NAME, this._attributes);
        String jwcId = this.findValueCaselessly(this._componentAttributeName, this._attributes);
        if (localizationKey != null && tagName.equalsIgnoreCase("span") && jwcId == null) {
            if (this._ignoring) {
                this.templateParseProblem(ParseMessages.componentMayNotBeIgnored(tagName, startLine), (Location)startLocation, startLine, cursorStart);
            }
            if (!emptyTag) {
                Tag tag = new Tag(tagName, startLine);
                tag._component = false;
                tag._removeTag = true;
                tag._ignoringBody = true;
                tag._mustBalance = true;
                this._stack.add(tag);
                this._ignoring = true;
            } else {
                this.advance();
            }
            this.addTextToken(cursorStart - 1);
            boolean raw = this.checkBoolean(RAW_ATTRIBUTE_NAME, this._attributes);
            Map attributes = this.filter(this._attributes, new String[]{LOCALIZATION_KEY_ATTRIBUTE_NAME, RAW_ATTRIBUTE_NAME});
            LocalizationToken token = this._factory.createLocalizationToken(tagName, localizationKey, raw, attributes, (Location)startLocation);
            this._tokens.add(token);
            return;
        }
        if (jwcId != null) {
            this.processComponentStart(tagName, jwcId, emptyTag, startLine, cursorStart, (Location)startLocation);
            return;
        }
        if (!emptyTag) {
            Tag tag = new Tag(tagName, startLine);
            this._stack.add(tag);
        }
        if (this._blockStart < 0 && !this._ignoring) {
            this._blockStart = cursorStart;
        }
        this.advance();
    }

    private void addAttributeIfUnique(String tagName, String attributeName, String attributeValue) throws TemplateParseException {
        if (this._attributes.containsKey(attributeName)) {
            this.templateParseProblem(ParseMessages.duplicateTagAttribute(tagName, this._line, attributeName), this.getCurrentLocation(), this._line, this._cursor);
        }
        this._attributes.put(attributeName, attributeValue);
    }

    protected void tagBeginEvent(int startLine, int cursorPosition) {
    }

    protected void tagEndEvent(int cursorPosition) {
    }

    protected void attributeBeginEvent(String attributeName, int startLine, int cursorPosition) {
    }

    protected void attributeEndEvent(int cursorPosition) {
    }

    private void processComponentStart(String tagName, String jwcId, boolean emptyTag, int startLine, int cursorStart, Location startLocation) throws TemplateParseException {
        boolean ignoreBody;
        String componentId = jwcId;
        if (componentId.equalsIgnoreCase(CONTENT_ID)) {
            this.processContentTag(tagName, startLine, cursorStart, emptyTag);
            return;
        }
        boolean isRemoveId = componentId.equalsIgnoreCase(REMOVE_ID);
        if (this._ignoring && !isRemoveId) {
            this.templateParseProblem(ParseMessages.componentMayNotBeIgnored(tagName, startLine), startLocation, startLine, cursorStart);
        }
        String type = null;
        boolean allowBody = false;
        if (this._patternMatcher.matches(componentId, this._implicitIdPattern)) {
            MatchResult match = this._patternMatcher.getMatch();
            componentId = match.group(1);
            type = match.group(2);
            String libraryId = match.group(4);
            String simpleType = match.group(5);
            if (componentId == null) {
                componentId = this._idAllocator.allocateId("$" + simpleType.replace('/', '$'));
            }
            try {
                allowBody = this._delegate.getAllowBody(libraryId, simpleType, startLocation);
            }
            catch (ApplicationRuntimeException e) {
                this.templateParseProblem(e, startLine, cursorStart);
            }
        } else if (!isRemoveId) {
            if (!this._patternMatcher.matches(componentId, this._simpleIdPattern)) {
                this.templateParseProblem(ParseMessages.componentIdInvalid(tagName, startLine, componentId), startLocation, startLine, cursorStart);
            }
            if (!this._delegate.getKnownComponent(componentId)) {
                this.templateParseProblem(ParseMessages.unknownComponentId(tagName, startLine, componentId), startLocation, startLine, cursorStart);
            }
            try {
                allowBody = this._delegate.getAllowBody(componentId, startLocation);
            }
            catch (ApplicationRuntimeException e) {
                this.templateParseProblem(e, startLine, cursorStart);
            }
        }
        boolean bl = ignoreBody = !emptyTag && (isRemoveId || !allowBody);
        if (this._ignoring && ignoreBody) {
            this.templateParseProblem(ParseMessages.nestedIgnore(tagName, startLine), (Location)new LocationImpl(this._resourceLocation, startLine), startLine, cursorStart);
        }
        if (!emptyTag) {
            this.pushNewTag(tagName, startLine, isRemoveId, ignoreBody);
        }
        this.addTextToken(cursorStart - 1);
        if (!isRemoveId) {
            this.addOpenToken(tagName, componentId, type, startLocation);
            if (emptyTag) {
                this._tokens.add(this._factory.createCloseToken(tagName, this.getCurrentLocation()));
            }
        }
        this.advance();
    }

    private void pushNewTag(String tagName, int startLine, boolean isRemoveId, boolean ignoreBody) {
        Tag tag = new Tag(tagName, startLine);
        tag._component = !isRemoveId;
        tag._removeTag = isRemoveId;
        this._ignoring = tag._ignoringBody = ignoreBody;
        tag._mustBalance = true;
        this._stack.add(tag);
    }

    private void processContentTag(String tagName, int startLine, int cursorStart, boolean emptyTag) throws TemplateParseException {
        if (this._ignoring) {
            this.templateParseProblem(ParseMessages.contentBlockMayNotBeIgnored(tagName, startLine), (Location)new LocationImpl(this._resourceLocation, startLine), startLine, cursorStart);
        }
        if (emptyTag) {
            this.templateParseProblem(ParseMessages.contentBlockMayNotBeEmpty(tagName, startLine), (Location)new LocationImpl(this._resourceLocation, startLine), startLine, cursorStart);
        }
        this._tokens.clear();
        this._blockStart = -1;
        Tag tag = new Tag(tagName, startLine);
        tag._mustBalance = true;
        tag._content = true;
        this._stack.clear();
        this._stack.add(tag);
        this.advance();
    }

    private void addOpenToken(String tagName, String jwcId, String type, Location location) {
        OpenToken token = this._factory.createOpenToken(tagName, jwcId, type, location);
        this._tokens.add(token);
        if (this._attributes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this._attributes.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equalsIgnoreCase(this._componentAttributeName)) continue;
            String value = (String)entry.getValue();
            this.addAttributeToToken(token, key, value);
        }
    }

    private void addAttributeToToken(OpenToken token, String name, String attributeValue) {
        token.addAttribute(name, this.convertEntitiesToPlain(attributeValue));
    }

    private void closeTag() throws TemplateParseException {
        int stackPos;
        int cursorStart = this._cursor;
        int length = this._templateData.length;
        int startLine = this._line;
        Location startLocation = this.getCurrentLocation();
        this._cursor += CLOSE_TAG.length;
        int tagStart = this._cursor;
        while (true) {
            char ch;
            if (this._cursor >= length) {
                this.templateParseProblem(ParseMessages.incompleteCloseTag(startLine), startLocation, startLine, cursorStart);
            }
            if ((ch = this._templateData[this._cursor]) == '>') break;
            this.advance();
        }
        String tagName = new String(this._templateData, tagStart, this._cursor - tagStart);
        Tag tag = null;
        for (stackPos = this._stack.size() - 1; stackPos >= 0 && !(tag = (Tag)this._stack.get(stackPos)).match(tagName); --stackPos) {
            if (!tag._mustBalance) continue;
            this.templateParseProblem(ParseMessages.improperlyNestedCloseTag(tagName, startLine, tag._tagName, tag._line), startLocation, startLine, cursorStart);
        }
        if (stackPos < 0) {
            this.templateParseProblem(ParseMessages.unmatchedCloseTag(tagName, startLine), startLocation, startLine, cursorStart);
        }
        if (tag._content) {
            this.addTextToken(cursorStart - 1);
            this._cursor = length;
            this._stack.clear();
            return;
        }
        if (tag._component) {
            this.addTextToken(cursorStart - 1);
            this._tokens.add(this._factory.createCloseToken(tagName, this.getCurrentLocation()));
        } else if (this._blockStart < 0 && !tag._removeTag && !this._ignoring) {
            this._blockStart = cursorStart;
        }
        for (int i = this._stack.size() - 1; i >= stackPos; --i) {
            this._stack.remove(i);
        }
        this.advance();
        if (tag._removeTag) {
            this.advanceOverWhitespace();
        }
        if (tag._ignoringBody) {
            this._ignoring = false;
        }
    }

    private void advance() {
        int length = this._templateData.length;
        if (this._cursor >= length) {
            return;
        }
        char ch = this._templateData[this._cursor];
        ++this._cursor;
        if (ch == '\n') {
            ++this._line;
            this._currentLocation = null;
            return;
        }
        if (ch == '\r') {
            ++this._line;
            this._currentLocation = null;
            if (this._cursor < length && this._templateData[this._cursor] == '\n') {
                ++this._cursor;
            }
            return;
        }
    }

    private void advanceOverWhitespace() {
        int length = this._templateData.length;
        while (this._cursor < length) {
            char ch = this._templateData[this._cursor];
            if (!Character.isWhitespace(ch)) {
                return;
            }
            this.advance();
        }
    }

    private Map filter(Map input, String[] removeKeys) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        HashMap result = null;
        block0: for (Map.Entry entry : input.entrySet()) {
            String key = (String)entry.getKey();
            for (int j = 0; j < removeKeys.length; ++j) {
                if (key.equalsIgnoreCase(removeKeys[j])) continue block0;
            }
            if (result == null) {
                result = new HashMap(input.size());
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    protected String findValueCaselessly(String key, Map map) {
        String result = (String)map.get(key);
        if (result != null) {
            return result;
        }
        for (Map.Entry entry : map.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private String convertEntitiesToPlain(String input) {
        int inputLength = input.length();
        StringBuffer buffer = new StringBuffer(inputLength);
        int cursor = 0;
        block0: while (cursor < inputLength) {
            for (int i = 0; i < CONVERSIONS.length; i += 2) {
                String entity = CONVERSIONS[i];
                int entityLength = entity.length();
                String value = CONVERSIONS[i + 1];
                if (cursor + entityLength > inputLength || !input.substring(cursor, cursor + entityLength).equals(entity)) continue;
                buffer.append(value);
                cursor += entityLength;
                continue block0;
            }
            buffer.append(input.charAt(cursor));
            ++cursor;
        }
        return buffer.toString().trim();
    }

    private boolean checkBoolean(String key, Map map) {
        String value = this.findValueCaselessly(key, map);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    protected Location getCurrentLocation() {
        if (this._currentLocation == null) {
            this._currentLocation = new LocationImpl(this._resourceLocation, this._line);
        }
        return this._currentLocation;
    }

    public void setFactory(TemplateTokenFactory factory) {
        this._factory = factory;
    }

    private static class Tag {
        String _tagName;
        boolean _component;
        boolean _ignoringBody;
        boolean _removeTag;
        boolean _mustBalance;
        int _line;
        boolean _content;

        Tag(String tagName, int line) {
            this._tagName = tagName;
            this._line = line;
        }

        boolean match(String matchTagName) {
            return this._tagName.equalsIgnoreCase(matchTagName);
        }
    }
}

