/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.DefaultErrorHandler;
import org.apache.hivemind.impl.LocationImpl;
import org.apache.hivemind.parse.AbstractParser;
import org.apache.tapestry.bean.BindingBeanInitializer;
import org.apache.tapestry.bean.LightweightBeanInitializer;
import org.apache.tapestry.binding.BindingSource;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.parse.BeanSetPropertySetter;
import org.apache.tapestry.parse.BindingSetter;
import org.apache.tapestry.parse.DescriptionSetter;
import org.apache.tapestry.parse.ExtensionConfigurationSetter;
import org.apache.tapestry.parse.ISpecificationParser;
import org.apache.tapestry.parse.ParseMessages;
import org.apache.tapestry.parse.PropertyValueSetter;
import org.apache.tapestry.spec.BeanLifecycle;
import org.apache.tapestry.spec.BindingType;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.spec.IBindingSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.spec.IExtensionSpecification;
import org.apache.tapestry.spec.ILibrarySpecification;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.spec.IPropertySpecification;
import org.apache.tapestry.spec.InjectSpecification;
import org.apache.tapestry.spec.SpecFactory;
import org.apache.tapestry.util.IPropertyHolder;
import org.apache.tapestry.util.RegexpMatcher;
import org.apache.tapestry.util.xml.DocumentParseException;
import org.apache.tapestry.util.xml.InvalidStringException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SpecificationParser
extends AbstractParser
implements ISpecificationParser {
    public static final String ASSET_NAME_PATTERN = "(\\$template)|(^_?[a-zA-Z]\\w*$)";
    public static final String BEAN_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String IDENTIFIER_PATTERN = "_?[a-zA-Z]\\w*";
    public static final String EXTENDED_IDENTIFIER_PATTERN = "_?[a-zA-Z](\\w|-)*";
    public static final String COMPONENT_ALIAS_PATTERN = "^(_?[a-zA-Z]\\w*/)*_?[a-zA-Z]\\w*$";
    public static final String COMPONENT_ID_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String COMPONENT_TYPE_PATTERN = "^(_?[a-zA-Z]\\w*:)?(_?[a-zA-Z]\\w*/)*_?[a-zA-Z]\\w*$";
    public static final String EXTENDED_PROPERTY_NAME_PATTERN = "^_?[a-zA-Z](\\w|-)*(\\._?[a-zA-Z](\\w|-)*)*$";
    public static final String EXTENSION_NAME_PATTERN = "^_?[a-zA-Z](\\w|-)*(\\._?[a-zA-Z](\\w|-)*)*$";
    public static final String LIBRARY_ID_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String PAGE_NAME_PATTERN = "^_?[a-zA-Z]\\w*(/_?[a-zA-Z]\\w*)*$";
    public static final String PARAMETER_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String PROPERTY_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String SERVICE_NAME_PATTERN = "^_?[a-zA-Z](\\w|-)*(\\._?[a-zA-Z](\\w|-)*)*$";
    public static final String TAPESTRY_DTD_3_0_PUBLIC_ID = "-//Apache Software Foundation//Tapestry Specification 3.0//EN";
    public static final String TAPESTRY_DTD_4_0_PUBLIC_ID = "-//Apache Software Foundation//Tapestry Specification 4.0//EN";
    public static final String TAPESTRY_DTD_4_1_PUBLIC_ID = "-//Apache Software Foundation//Tapestry Specification 4.1//EN";
    private static final int STATE_ALLOW_DESCRIPTION = 2000;
    private static final int STATE_ALLOW_PROPERTY = 2001;
    private static final int STATE_APPLICATION_SPECIFICATION_INITIAL = 1002;
    private static final int STATE_BEAN = 4;
    private static final int STATE_BINDING_3_0 = 7;
    private static final int STATE_BINDING = 100;
    private static final int STATE_COMPONENT = 6;
    private static final int STATE_COMPONENT_SPECIFICATION = 1;
    private static final int STATE_COMPONENT_SPECIFICATION_INITIAL = 1000;
    private static final int STATE_CONFIGURE = 14;
    private static final int STATE_DESCRIPTION = 2;
    private static final int STATE_EXTENSION = 13;
    private static final int STATE_LIBRARY_SPECIFICATION = 12;
    private static final int STATE_LIBRARY_SPECIFICATION_INITIAL = 1003;
    private static final int STATE_LISTENER_BINDING = 8;
    private static final int STATE_NO_CONTENT = 3000;
    private static final int STATE_PAGE_SPECIFICATION = 11;
    private static final int STATE_PAGE_SPECIFICATION_INITIAL = 1001;
    private static final int STATE_META = 3;
    private static final int STATE_PROPERTY = 10;
    private static final int STATE_SET = 5;
    private static final int STATE_STATIC_BINDING = 9;
    private final Map _conversionMap = new HashMap();
    private final Log _log;
    private final ErrorHandler _errorHandler;
    private boolean _dtd40;
    private Map _attributes;
    private String _elementName;
    private final SpecFactory _factory;
    private RegexpMatcher _matcher = new RegexpMatcher();
    private SAXParser _parser;
    private SAXParserFactory _parserFactory = SAXParserFactory.newInstance();
    private final ClassResolver _resolver;
    private BindingSource _bindingSource;
    private Object _rootObject;
    private ValueConverter _valueConverter;

    public SpecificationParser(ClassResolver resolver) {
        this(resolver, new SpecFactory());
    }

    public SpecificationParser(ClassResolver resolver, SpecFactory factory) {
        this((ErrorHandler)new DefaultErrorHandler(), LogFactory.getLog(SpecificationParser.class), resolver, factory);
    }

    public SpecificationParser(ErrorHandler errorHandler, Log log, ClassResolver resolver, SpecFactory factory) {
        this._conversionMap.put("true", Boolean.TRUE);
        this._conversionMap.put("t", Boolean.TRUE);
        this._conversionMap.put("1", Boolean.TRUE);
        this._conversionMap.put("y", Boolean.TRUE);
        this._conversionMap.put("yes", Boolean.TRUE);
        this._conversionMap.put("on", Boolean.TRUE);
        this._conversionMap.put("aye", Boolean.TRUE);
        this._conversionMap.put("false", Boolean.FALSE);
        this._conversionMap.put("f", Boolean.FALSE);
        this._conversionMap.put("0", Boolean.FALSE);
        this._conversionMap.put("off", Boolean.FALSE);
        this._conversionMap.put("no", Boolean.FALSE);
        this._conversionMap.put("n", Boolean.FALSE);
        this._conversionMap.put("nay", Boolean.FALSE);
        this._conversionMap.put("none", BeanLifecycle.NONE);
        this._conversionMap.put("request", BeanLifecycle.REQUEST);
        this._conversionMap.put("page", BeanLifecycle.PAGE);
        this._conversionMap.put("render", BeanLifecycle.RENDER);
        this._parserFactory.setNamespaceAware(false);
        this._parserFactory.setValidating(true);
        this._errorHandler = errorHandler;
        this._log = log;
        this._resolver = resolver;
        this._factory = factory;
    }

    protected void begin(String elementName, Map attributes) {
        this._elementName = elementName;
        this._attributes = attributes;
        switch (this.getState()) {
            case 1000: {
                this.beginComponentSpecificationInitial();
                break;
            }
            case 1001: {
                this.beginPageSpecificationInitial();
                break;
            }
            case 1002: {
                this.beginApplicationSpecificationInitial();
                break;
            }
            case 1003: {
                this.beginLibrarySpecificationInitial();
                break;
            }
            case 1: {
                this.beginComponentSpecification();
                break;
            }
            case 11: {
                this.beginPageSpecification();
                break;
            }
            case 2000: {
                this.beginAllowDescription();
                break;
            }
            case 2001: {
                this.allowMetaData();
                break;
            }
            case 4: {
                this.beginBean();
                break;
            }
            case 6: {
                this.beginComponent();
                break;
            }
            case 12: {
                this.beginLibrarySpecification();
                break;
            }
            case 13: {
                this.beginExtension();
                break;
            }
            default: {
                this.unexpectedElement(this._elementName);
            }
        }
    }

    private void beginAllowDescription() {
        if (this._elementName.equals("description")) {
            this.enterDescription();
            return;
        }
        this.unexpectedElement(this._elementName);
    }

    private void allowMetaData() {
        if (this._dtd40) {
            if (this._elementName.equals("meta")) {
                this.enterMeta();
                return;
            }
        } else if (this._elementName.equals("property")) {
            this.enterProperty30();
            return;
        }
        this.unexpectedElement(this._elementName);
    }

    private void beginApplicationSpecificationInitial() {
        this.expectElement("application");
        String name = this.getAttribute("name");
        String engineClassName = this.getAttribute("engine-class");
        IApplicationSpecification as = this._factory.createApplicationSpecification();
        as.setName(name);
        if (HiveMind.isNonBlank((String)engineClassName)) {
            as.setEngineClassName(engineClassName);
        }
        this._rootObject = as;
        this.push(this._elementName, as, 12);
    }

    private void beginBean() {
        if (this._elementName.equals("set")) {
            this.enterSet();
            return;
        }
        if (this._elementName.equals("set-property")) {
            this.enterSetProperty30();
            return;
        }
        if (this._elementName.equals("set-message-property")) {
            this.enterSetMessage30();
            return;
        }
        if (this._elementName.equals("description")) {
            this.enterDescription();
            return;
        }
        this.allowMetaData();
    }

    private void beginComponent() {
        if (this._elementName.equals("binding")) {
            this.enterBinding();
            return;
        }
        if (this._elementName.equals("static-binding")) {
            this.enterStaticBinding30();
            return;
        }
        if (this._elementName.equals("message-binding")) {
            this.enterMessageBinding30();
            return;
        }
        if (this._elementName.equals("inherited-binding")) {
            this.enterInheritedBinding30();
            return;
        }
        if (this._elementName.equals("listener-binding")) {
            this.enterListenerBinding();
            return;
        }
        this.allowMetaData();
    }

    private void beginComponentSpecification() {
        if (this._elementName.equals("reserved-parameter")) {
            this.enterReservedParameter();
            return;
        }
        if (this._elementName.equals("parameter")) {
            this.enterParameter();
            return;
        }
        this.beginPageSpecification();
    }

    private void beginComponentSpecificationInitial() {
        this.expectElement("component-specification");
        IComponentSpecification cs = this._factory.createComponentSpecification();
        cs.setAllowBody(this.getBooleanAttribute("allow-body", true));
        cs.setAllowInformalParameters(this.getBooleanAttribute("allow-informal-parameters", true));
        cs.setDeprecated(this.getBooleanAttribute("deprecated", false));
        String className = this.getAttribute("class");
        if (className != null) {
            cs.setComponentClassName(className);
        }
        cs.setSpecificationLocation(this.getResource());
        this._rootObject = cs;
        this.push(this._elementName, cs, 1);
    }

    private void beginExtension() {
        if (this._elementName.equals("configure")) {
            this.enterConfigure();
            return;
        }
        this.allowMetaData();
    }

    private void beginLibrarySpecification() {
        if (this._elementName.equals("description")) {
            this.enterDescription();
            return;
        }
        if (this._elementName.equals("page")) {
            this.enterPage();
            return;
        }
        if (this._elementName.equals("component-type")) {
            this.enterComponentType();
            return;
        }
        if (this._elementName.equals("service")) {
            this.enterService30();
            return;
        }
        if (this._elementName.equals("library")) {
            this.enterLibrary();
            return;
        }
        if (this._elementName.equals("extension")) {
            this.enterExtension();
            return;
        }
        this.allowMetaData();
    }

    private void beginLibrarySpecificationInitial() {
        this.expectElement("library-specification");
        ILibrarySpecification ls = this._factory.createLibrarySpecification();
        this._rootObject = ls;
        this.push(this._elementName, ls, 12);
    }

    private void beginPageSpecification() {
        if (this._elementName.equals("component")) {
            this.enterComponent();
            return;
        }
        if (this._elementName.equals("bean")) {
            this.enterBean();
            return;
        }
        if (this._elementName.equals("property-specification") || this._dtd40 && this._elementName.equals("property")) {
            this.enterProperty();
            return;
        }
        if (this._elementName.equals("inject")) {
            this.enterInject();
            return;
        }
        if (this._elementName.equals("asset")) {
            this.enterAsset();
            return;
        }
        if (this._elementName.equals("context-asset")) {
            this.enterContextAsset30();
            return;
        }
        if (this._elementName.equals("private-asset")) {
            this.enterPrivateAsset30();
            return;
        }
        if (this._elementName.equals("external-asset")) {
            this.enterExternalAsset30();
            return;
        }
        if (this._elementName.equals("description")) {
            this.enterDescription();
            return;
        }
        this.allowMetaData();
    }

    private void beginPageSpecificationInitial() {
        this.expectElement("page-specification");
        IComponentSpecification cs = this._factory.createComponentSpecification();
        String className = this.getAttribute("class");
        if (className != null) {
            cs.setComponentClassName(className);
        }
        cs.setSpecificationLocation(this.getResource());
        cs.setPageSpecification(true);
        this._rootObject = cs;
        this.push(this._elementName, cs, 11);
    }

    private void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void copyBindings(String sourceComponentId, IComponentSpecification cs, IContainedComponent target) {
        IContainedComponent source = cs.getComponent(sourceComponentId);
        if (source == null) {
            throw new DocumentParseException(ParseMessages.unableToCopy(sourceComponentId), this.getLocation());
        }
        for (String bindingName : source.getBindingNames()) {
            IBindingSpecification binding = source.getBinding(bindingName);
            target.setBinding(bindingName, binding);
        }
        target.setType(source.getType());
    }

    protected void end(String elementName) {
        this._elementName = elementName;
        switch (this.getState()) {
            case 2: {
                this.endDescription();
                break;
            }
            case 3: {
                this.endProperty();
                break;
            }
            case 5: {
                this.endSetProperty();
                break;
            }
            case 7: {
                this.endBinding30();
                break;
            }
            case 100: {
                this.endBinding();
                break;
            }
            case 9: {
                this.endStaticBinding();
                break;
            }
            case 10: {
                this.endPropertySpecification();
                break;
            }
            case 12: {
                this.endLibrarySpecification();
                break;
            }
            case 14: {
                this.endConfigure();
                break;
            }
        }
        this.pop();
    }

    private void endBinding30() {
        BindingSetter bs = (BindingSetter)((Object)this.peekObject());
        String expression = this.getExtendedValue(bs.getValue(), "expression", true);
        IBindingSpecification spec = this._factory.createBindingSpecification();
        spec.setType(BindingType.PREFIXED);
        spec.setValue("ognl:" + expression);
        bs.apply(spec);
    }

    private void endConfigure() {
        ExtensionConfigurationSetter setter = (ExtensionConfigurationSetter)((Object)this.peekObject());
        String finalValue = this.getExtendedValue(setter.getValue(), "value", true);
        setter.apply(finalValue);
    }

    private void endDescription() {
        DescriptionSetter setter = (DescriptionSetter)((Object)this.peekObject());
        String description = this.peekContent();
        setter.apply(description);
    }

    private void endLibrarySpecification() {
        ILibrarySpecification spec = (ILibrarySpecification)this.peekObject();
        spec.setSpecificationLocation(this.getResource());
        spec.instantiateImmediateExtensions();
    }

    private void endProperty() {
        PropertyValueSetter pvs = (PropertyValueSetter)this.peekObject();
        String finalValue = this.getExtendedValue(pvs.getPropertyValue(), "value", true);
        pvs.applyValue(finalValue);
    }

    private void endPropertySpecification() {
        IPropertySpecification ps = (IPropertySpecification)this.peekObject();
        String initialValue = this.getExtendedValue(ps.getInitialValue(), "initial-value", false);
        if (initialValue != null && !this._dtd40) {
            initialValue = "ognl:" + initialValue;
        }
        ps.setInitialValue(initialValue);
    }

    private void endSetProperty() {
        BeanSetPropertySetter bs = (BeanSetPropertySetter)((Object)this.peekObject());
        String finalValue = this.getExtendedValue(bs.getBindingReference(), "expression", true);
        bs.applyBindingReference(finalValue);
    }

    private void endStaticBinding() {
        BindingSetter bs = (BindingSetter)((Object)this.peekObject());
        String literalValue = this.getExtendedValue(bs.getValue(), "value", true);
        IBindingSpecification spec = this._factory.createBindingSpecification();
        spec.setType(BindingType.PREFIXED);
        spec.setValue("literal:" + literalValue);
        bs.apply(spec);
    }

    private void enterAsset(String pathAttributeName, String prefix) {
        String name = this.getValidatedAttribute("name", ASSET_NAME_PATTERN, "invalid-asset-name");
        String path = this.getAttribute(pathAttributeName);
        String propertyName = this.getValidatedAttribute("property", "^_?[a-zA-Z]\\w*$", "invalid-property-name");
        IAssetSpecification ia = this._factory.createAssetSpecification();
        ia.setPath(prefix == null ? path : prefix + path);
        ia.setPropertyName(propertyName);
        IComponentSpecification cs = (IComponentSpecification)this.peekObject();
        cs.addAsset(name, ia);
        this.push(this._elementName, ia, 2001);
    }

    private void enterBean() {
        String name = this.getValidatedAttribute("name", "^_?[a-zA-Z]\\w*$", "invalid-bean-name");
        String classAttribute = this.getAttribute("class");
        int commax = classAttribute.indexOf(44);
        String className = commax < 0 ? classAttribute : classAttribute.substring(0, commax);
        BeanLifecycle lifecycle = (BeanLifecycle)this.getConvertedAttribute("lifecycle", BeanLifecycle.REQUEST);
        String propertyName = this.getValidatedAttribute("property", "^_?[a-zA-Z]\\w*$", "invalid-property-name");
        IBeanSpecification bs = this._factory.createBeanSpecification();
        bs.setClassName(className);
        bs.setLifecycle(lifecycle);
        bs.setPropertyName(propertyName);
        if (commax > 0) {
            String initializer = classAttribute.substring(commax + 1);
            bs.addInitializer(new LightweightBeanInitializer(initializer));
        }
        IComponentSpecification cs = (IComponentSpecification)this.peekObject();
        cs.addBeanSpecification(name, bs);
        this.push(this._elementName, bs, 4);
    }

    private void enterBinding() {
        if (!this._dtd40) {
            this.enterBinding30();
            return;
        }
        String name = this.getValidatedAttribute("name", "^_?[a-zA-Z]\\w*$", "invalid-parameter-name");
        String value = this.getAttribute("value");
        IContainedComponent cc = (IContainedComponent)this.peekObject();
        BindingSetter bs = new BindingSetter(cc, name, value);
        this.push(this._elementName, (Object)bs, 100, false);
    }

    private void endBinding() {
        BindingSetter bs = (BindingSetter)((Object)this.peekObject());
        String value = this.getExtendedValue(bs.getValue(), "value", true);
        IBindingSpecification spec = this._factory.createBindingSpecification();
        spec.setType(BindingType.PREFIXED);
        spec.setValue(value);
        bs.apply(spec);
    }

    private void enterBinding30() {
        String name = this.getAttribute("name");
        String expression = this.getAttribute("expression");
        IContainedComponent cc = (IContainedComponent)this.peekObject();
        BindingSetter bs = new BindingSetter(cc, name, expression);
        this.push(this._elementName, (Object)bs, 7, false);
    }

    private void enterComponent() {
        String id = this.getValidatedAttribute("id", "^_?[a-zA-Z]\\w*$", "invalid-component-id");
        String type = this.getValidatedAttribute("type", COMPONENT_TYPE_PATTERN, "invalid-component-type");
        String copyOf = this.getAttribute("copy-of");
        boolean inherit = this.getBooleanAttribute("inherit-informal-parameters", false);
        String propertyName = this.getValidatedAttribute("property", "^_?[a-zA-Z]\\w*$", "invalid-property-name");
        boolean hasCopyOf = HiveMind.isNonBlank((String)copyOf);
        if (hasCopyOf) {
            if (HiveMind.isNonBlank((String)type)) {
                throw new DocumentParseException(ParseMessages.bothTypeAndCopyOf(id), this.getLocation());
            }
        } else if (HiveMind.isBlank((String)type)) {
            throw new DocumentParseException(ParseMessages.missingTypeOrCopyOf(id), this.getLocation());
        }
        IContainedComponent cc = this._factory.createContainedComponent();
        cc.setType(type);
        cc.setCopyOf(copyOf);
        cc.setInheritInformalParameters(inherit);
        cc.setPropertyName(propertyName);
        IComponentSpecification cs = (IComponentSpecification)this.peekObject();
        cs.addComponent(id, cc);
        if (hasCopyOf) {
            this.copyBindings(copyOf, cs, cc);
        }
        this.push(this._elementName, cc, 6);
    }

    private void enterComponentType() {
        String type = this.getValidatedAttribute("type", COMPONENT_ALIAS_PATTERN, "invalid-component-type");
        String path = this.getAttribute("specification-path");
        ILibrarySpecification ls = (ILibrarySpecification)this.peekObject();
        ls.setComponentSpecificationPath(type, path);
        this.push(this._elementName, null, 3000);
    }

    private void enterConfigure() {
        String attributeName = this._dtd40 ? "property" : "property-name";
        String propertyName = this.getValidatedAttribute(attributeName, "^_?[a-zA-Z]\\w*$", "invalid-property-name");
        String value = this.getAttribute("value");
        IExtensionSpecification es = (IExtensionSpecification)this.peekObject();
        ExtensionConfigurationSetter setter = new ExtensionConfigurationSetter(es, propertyName, value);
        this.push(this._elementName, (Object)setter, 14, false);
    }

    private void enterContextAsset30() {
        this.enterAsset("path", "context:");
    }

    private void enterAsset() {
        this.enterAsset("path", null);
    }

    private void enterDescription() {
        this.push(this._elementName, (Object)new DescriptionSetter(this.peekObject()), 2, false);
    }

    private void enterExtension() {
        String name = this.getValidatedAttribute("name", "^_?[a-zA-Z](\\w|-)*(\\._?[a-zA-Z](\\w|-)*)*$", "invalid-extension-name");
        boolean immediate = this.getBooleanAttribute("immediate", false);
        String className = this.getAttribute("class");
        IExtensionSpecification es = this._factory.createExtensionSpecification(this._resolver, this._valueConverter);
        es.setClassName(className);
        es.setImmediate(immediate);
        ILibrarySpecification ls = (ILibrarySpecification)this.peekObject();
        ls.addExtensionSpecification(name, es);
        this.push(this._elementName, es, 13);
    }

    private void enterExternalAsset30() {
        this.enterAsset("URL", null);
    }

    private void enterInheritedBinding30() {
        String name = this.getAttribute("name");
        String parameterName = this.getAttribute("parameter-name");
        IBindingSpecification bs = this._factory.createBindingSpecification();
        bs.setType(BindingType.INHERITED);
        bs.setValue(parameterName);
        IContainedComponent cc = (IContainedComponent)this.peekObject();
        cc.setBinding(name, bs);
        this.push(this._elementName, null, 3000);
    }

    private void enterLibrary() {
        String libraryId = this.getValidatedAttribute("id", "^_?[a-zA-Z]\\w*$", "invalid-library-id");
        String path = this.getAttribute("specification-path");
        if (libraryId.equals("framework") || libraryId.equals("application")) {
            throw new DocumentParseException(ParseMessages.frameworkLibraryIdIsReserved("framework"), this.getLocation());
        }
        ILibrarySpecification ls = (ILibrarySpecification)this.peekObject();
        ls.setLibrarySpecificationPath(libraryId, path);
        this.push(this._elementName, null, 3000);
    }

    private void enterListenerBinding() {
        this._log.warn(ParseMessages.listenerBindingUnsupported(this.getLocation()));
        this.push(this._elementName, null, 8, false);
    }

    private void enterMessageBinding30() {
        String name = this.getAttribute("name");
        String key = this.getAttribute("key");
        IBindingSpecification bs = this._factory.createBindingSpecification();
        bs.setType(BindingType.PREFIXED);
        bs.setValue("message:" + key);
        bs.setLocation(this.getLocation());
        IContainedComponent cc = (IContainedComponent)this.peekObject();
        cc.setBinding(name, bs);
        this.push(this._elementName, null, 3000);
    }

    private void enterPage() {
        String name = this.getValidatedAttribute("name", PAGE_NAME_PATTERN, "invalid-page-name");
        String path = this.getAttribute("specification-path");
        ILibrarySpecification ls = (ILibrarySpecification)this.peekObject();
        ls.setPageSpecificationPath(name, path);
        this.push(this._elementName, null, 3000);
    }

    private void enterParameter() {
        IParameterSpecification ps = this._factory.createParameterSpecification();
        String name = this.getValidatedAttribute("name", "^_?[a-zA-Z]\\w*$", "invalid-parameter-name");
        String attributeName = this._dtd40 ? "property" : "property-name";
        String propertyName = this.getValidatedAttribute(attributeName, "^_?[a-zA-Z]\\w*$", "invalid-property-name");
        if (propertyName == null) {
            propertyName = name;
        }
        ps.setParameterName(name);
        ps.setPropertyName(propertyName);
        ps.setRequired(this.getBooleanAttribute("required", false));
        String defaultValue = this.getAttribute("default-value");
        if (defaultValue != null && !this._dtd40) {
            defaultValue = "ognl:" + defaultValue;
        }
        ps.setDefaultValue(defaultValue);
        if (!this._dtd40) {
            String direction = this.getAttribute("direction");
            ps.setCache(!"auto".equals(direction));
        } else {
            boolean cache = this.getBooleanAttribute("cache", true);
            ps.setCache(cache);
        }
        String type = this.getAttribute("type");
        if (type != null) {
            ps.setType(type);
        }
        String aliases = this.getAttribute("aliases");
        ps.setAliases(aliases);
        ps.setDeprecated(this.getBooleanAttribute("deprecated", false));
        IComponentSpecification cs = (IComponentSpecification)this.peekObject();
        cs.addParameter(ps);
        this.push(this._elementName, ps, 2000);
    }

    private void enterPrivateAsset30() {
        this.enterAsset("resource-path", "classpath:");
    }

    private void enterMeta() {
        String key = this.getAttribute("key");
        String value = this.getAttribute("value");
        IPropertyHolder ph = (IPropertyHolder)this.peekObject();
        this.push(this._elementName, new PropertyValueSetter(ph, key, value), 3, false);
    }

    private void enterProperty30() {
        String name = this.getAttribute("name");
        String value = this.getAttribute("value");
        IPropertyHolder ph = (IPropertyHolder)this.peekObject();
        this.push(this._elementName, new PropertyValueSetter(ph, name, value), 3, false);
    }

    private void enterProperty() {
        String name = this.getValidatedAttribute("name", "^_?[a-zA-Z]\\w*$", "invalid-property-name");
        String type = this.getAttribute("type");
        String persistence = null;
        persistence = this._dtd40 ? this.getAttribute("persist") : (this.getBooleanAttribute("persistent", false) ? "session" : null);
        String initialValue = this.getAttribute("initial-value");
        IPropertySpecification ps = this._factory.createPropertySpecification();
        ps.setName(name);
        if (HiveMind.isNonBlank((String)type)) {
            ps.setType(type);
        }
        ps.setPersistence(persistence);
        ps.setInitialValue(initialValue);
        IComponentSpecification cs = (IComponentSpecification)this.peekObject();
        cs.addPropertySpecification(ps);
        this.push(this._elementName, ps, 10, false);
    }

    private void enterInject() {
        String property = this.getValidatedAttribute("property", "^_?[a-zA-Z]\\w*$", "invalid-property-name");
        String type = this.getAttribute("type");
        String objectReference = this.getAttribute("object");
        InjectSpecification spec = this._factory.createInjectSpecification();
        spec.setProperty(property);
        spec.setType(type);
        spec.setObject(objectReference);
        IComponentSpecification cs = (IComponentSpecification)this.peekObject();
        cs.addInjectSpecification(spec);
        this.push(this._elementName, spec, 3000);
    }

    private void enterReservedParameter() {
        String name = this.getAttribute("name");
        IComponentSpecification cs = (IComponentSpecification)this.peekObject();
        cs.addReservedParameterName(name);
        this.push(this._elementName, null, 3000);
    }

    private void enterService30() {
        this._errorHandler.error(this._log, ParseMessages.serviceElementNotSupported(), this.getLocation(), null);
        this.push(this._elementName, null, 3000);
    }

    private void enterSetMessage30() {
        String name = this.getAttribute("name");
        String key = this.getAttribute("key");
        BindingBeanInitializer bi = this._factory.createBindingBeanInitializer(this._bindingSource);
        bi.setPropertyName(name);
        bi.setBindingReference("message:" + key);
        bi.setLocation(this.getLocation());
        IBeanSpecification bs = (IBeanSpecification)this.peekObject();
        bs.addInitializer(bi);
        this.push(this._elementName, null, 3000);
    }

    private void enterSet() {
        String name = this.getAttribute("name");
        String reference = this.getAttribute("value");
        BindingBeanInitializer bi = this._factory.createBindingBeanInitializer(this._bindingSource);
        bi.setPropertyName(name);
        IBeanSpecification bs = (IBeanSpecification)this.peekObject();
        this.push(this._elementName, (Object)new BeanSetPropertySetter(bs, bi, null, reference), 5, false);
    }

    private void enterSetProperty30() {
        String name = this.getAttribute("name");
        String expression = this.getAttribute("expression");
        BindingBeanInitializer bi = this._factory.createBindingBeanInitializer(this._bindingSource);
        bi.setPropertyName(name);
        IBeanSpecification bs = (IBeanSpecification)this.peekObject();
        this.push(this._elementName, (Object)new BeanSetPropertySetter(bs, bi, "ognl:", expression), 5, false);
    }

    private void enterStaticBinding30() {
        String name = this.getAttribute("name");
        String expression = this.getAttribute("value");
        IContainedComponent cc = (IContainedComponent)this.peekObject();
        BindingSetter bs = new BindingSetter(cc, name, expression);
        this.push(this._elementName, (Object)bs, 9, false);
    }

    private void expectElement(String elementName) {
        if (this._elementName.equals(elementName)) {
            return;
        }
        throw new DocumentParseException(ParseMessages.incorrectDocumentType(this._elementName, elementName), this.getLocation(), null);
    }

    private String getAttribute(String name) {
        return (String)this._attributes.get(name);
    }

    private boolean getBooleanAttribute(String name, boolean defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        Boolean b = (Boolean)this._conversionMap.get(value);
        return b;
    }

    private Object getConvertedAttribute(String name, Object defaultValue) {
        String key = this.getAttribute(name);
        if (key == null) {
            return defaultValue;
        }
        return this._conversionMap.get(key);
    }

    private InputSource getDTDInputSource(String name) {
        InputStream stream = this.getClass().getResourceAsStream(name);
        return new InputSource(stream);
    }

    private String getExtendedValue(String attributeValue, String attributeName, boolean required) {
        String contentValue = this.peekContent();
        boolean asAttribute = HiveMind.isNonBlank((String)attributeValue);
        boolean asContent = HiveMind.isNonBlank((String)contentValue);
        if (asAttribute && asContent) {
            throw new DocumentParseException(ParseMessages.noAttributeAndBody(attributeName, this._elementName), this.getLocation(), null);
        }
        if (required && !asAttribute && !asContent) {
            throw new DocumentParseException(ParseMessages.requiredExtendedAttribute(this._elementName, attributeName), this.getLocation(), null);
        }
        if (asAttribute) {
            return attributeValue;
        }
        return contentValue;
    }

    private String getValidatedAttribute(String name, String pattern, String errorKey) {
        String value = this.getAttribute(name);
        if (value == null) {
            return null;
        }
        if (this._matcher.matches(pattern, value)) {
            return value;
        }
        throw new InvalidStringException(ParseMessages.invalidAttribute(errorKey, value), value, this.getLocation());
    }

    protected void initializeParser(Resource resource, int startState) {
        super.initializeParser(resource, startState);
        this._rootObject = null;
        this._attributes = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IApplicationSpecification parseApplicationSpecification(Resource resource) {
        this.initializeParser(resource, 1002);
        try {
            this.parseDocument();
            IApplicationSpecification iApplicationSpecification = (IApplicationSpecification)this._rootObject;
            return iApplicationSpecification;
        }
        finally {
            this.resetParser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentSpecification parseComponentSpecification(Resource resource) {
        this.initializeParser(resource, 1000);
        try {
            this.parseDocument();
            IComponentSpecification iComponentSpecification = (IComponentSpecification)this._rootObject;
            return iComponentSpecification;
        }
        finally {
            this.resetParser();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseDocument() {
        BufferedInputStream stream = null;
        Resource resource = this.getResource();
        boolean success = false;
        try {
            URL resourceURL;
            if (this._parser == null) {
                this._parser = this._parserFactory.newSAXParser();
            }
            if ((resourceURL = resource.getResourceURL()) == null) {
                throw new DocumentParseException(ParseMessages.missingResource(resource), resource);
            }
            InputStream rawStream = resourceURL.openStream();
            stream = new BufferedInputStream(rawStream);
            this._parser.parse((InputStream)stream, (DefaultHandler)((Object)this), resourceURL.toExternalForm());
            ((InputStream)stream).close();
            stream = null;
            success = true;
            if (!success) {
                this._parser = null;
            }
            this.close(stream);
            return;
        }
        catch (SAXParseException ex) {
            try {
                this._parser = null;
                LocationImpl location = new LocationImpl(resource, ex.getLineNumber(), ex.getColumnNumber());
                throw new DocumentParseException(ParseMessages.errorReadingResource(resource, ex), (Location)location, (Throwable)ex);
                catch (Exception ex2) {
                    this._parser = null;
                    throw new DocumentParseException(ParseMessages.errorReadingResource(resource, ex2), resource, (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                if (!success) {
                    this._parser = null;
                }
                this.close(stream);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILibrarySpecification parseLibrarySpecification(Resource resource) {
        this.initializeParser(resource, 1003);
        try {
            this.parseDocument();
            ILibrarySpecification iLibrarySpecification = (ILibrarySpecification)this._rootObject;
            return iLibrarySpecification;
        }
        finally {
            this.resetParser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponentSpecification parsePageSpecification(Resource resource) {
        this.initializeParser(resource, 1001);
        try {
            this.parseDocument();
            IComponentSpecification iComponentSpecification = (IComponentSpecification)this._rootObject;
            return iComponentSpecification;
        }
        finally {
            this.resetParser();
        }
    }

    protected String peekContent() {
        String content = super.peekContent();
        if (content == null) {
            return null;
        }
        return content.trim();
    }

    protected void resetParser() {
        this._rootObject = null;
        this._dtd40 = false;
        this._attributes.clear();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (TAPESTRY_DTD_4_0_PUBLIC_ID.equals(publicId)) {
            this._dtd40 = true;
            return this.getDTDInputSource("Tapestry_4_0.dtd");
        }
        if (TAPESTRY_DTD_4_1_PUBLIC_ID.equals(publicId)) {
            this._dtd40 = true;
            return this.getDTDInputSource("Tapestry_4_1.dtd");
        }
        if (TAPESTRY_DTD_3_0_PUBLIC_ID.equals(publicId)) {
            return this.getDTDInputSource("Tapestry_3_0.dtd");
        }
        throw new DocumentParseException(ParseMessages.unknownPublicId(this.getResource(), publicId), (Location)new LocationImpl(this.getResource()), null);
    }

    public void setBindingSource(BindingSource bindingSource) {
        this._bindingSource = bindingSource;
    }

    public void setValueConverter(ValueConverter valueConverter) {
        this._valueConverter = valueConverter;
    }
}

