/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.MessageFormatter;
import org.apache.tapestry.parse.TemplateToken;

final class ParseMessages {
    private static final MessageFormatter _formatter = new MessageFormatter(ParseMessages.class);

    private ParseMessages() {
    }

    static String commentNotEnded(int line) {
        return _formatter.format("comment-not-ended", (Object)new Integer(line));
    }

    static String unclosedUnknownTag(int line) {
        return _formatter.format("unclosed-unknown-tag", (Object)new Integer(line));
    }

    static String unclosedTag(String tagName, int line) {
        return _formatter.format("unclosed-tag", (Object)tagName, (Object)new Integer(line));
    }

    static String missingAttributeValue(String tagName, int line, String attributeName) {
        return _formatter.format("missing-attribute-value", (Object)tagName, (Object)new Integer(line), (Object)attributeName);
    }

    static String componentMayNotBeIgnored(String tagName, int line) {
        return _formatter.format("component-may-not-be-ignored", (Object)tagName, (Object)new Integer(line));
    }

    static String componentIdInvalid(String tagName, int line, String jwcid) {
        return _formatter.format("component-id-invalid", (Object)tagName, (Object)new Integer(line), (Object)jwcid);
    }

    static String unknownComponentId(String tagName, int line, String jwcid) {
        return _formatter.format("unknown-component-id", (Object)tagName, (Object)new Integer(line), (Object)jwcid);
    }

    static String nestedIgnore(String tagName, int line) {
        return _formatter.format("nested-ignore", (Object)tagName, (Object)new Integer(line));
    }

    static String contentBlockMayNotBeIgnored(String tagName, int line) {
        return _formatter.format("content-block-may-not-be-ignored", (Object)tagName, (Object)new Integer(line));
    }

    static String contentBlockMayNotBeEmpty(String tagName, int line) {
        return _formatter.format("content-block-may-not-be-empty", (Object)tagName, (Object)new Integer(line));
    }

    static String incompleteCloseTag(int line) {
        return _formatter.format("incomplete-close-tag", (Object)new Integer(line));
    }

    static String improperlyNestedCloseTag(String tagName, int closeLine, String startTagName, int startLine) {
        return _formatter.format("improperly-nested-close-tag", new Object[]{tagName, new Integer(closeLine), startTagName, new Integer(startLine)});
    }

    static String unmatchedCloseTag(String tagName, int line) {
        return _formatter.format("unmatched-close-tag", (Object)tagName, (Object)new Integer(line));
    }

    static String failConvertBoolean(String value) {
        return _formatter.format("fail-convert-boolean", (Object)value);
    }

    static String failConvertDouble(String value) {
        return _formatter.format("fail-convert-double", (Object)value);
    }

    static String failConvertInt(String value) {
        return _formatter.format("fail-convert-int", (Object)value);
    }

    static String failConvertLong(String value) {
        return _formatter.format("fail-convert-long", (Object)value);
    }

    static String unableToCopy(String id) {
        return _formatter.format("unable-to-copy", (Object)id);
    }

    static String bothTypeAndCopyOf(String id) {
        return _formatter.format("both-type-and-copy-of", (Object)id);
    }

    static String missingTypeOrCopyOf(String id) {
        return _formatter.format("missing-type-or-copy-of", (Object)id);
    }

    static String frameworkLibraryIdIsReserved(String id) {
        return _formatter.format("framework-library-id-is-reserved", (Object)id);
    }

    static String incorrectDocumentType(String expected, String actual) {
        return _formatter.format("incorrect-document-type", (Object)expected, (Object)actual);
    }

    static String noAttributeAndBody(String attributeName, String elementName) {
        return _formatter.format("no-attribute-and-body", (Object)attributeName, (Object)elementName);
    }

    static String requiredExtendedAttribute(String elementName, String attributeName) {
        return _formatter.format("required-extended-attribute", (Object)elementName, (Object)attributeName);
    }

    static String invalidAttribute(String key, String value) {
        return _formatter.format(key, (Object)value);
    }

    static String missingResource(Resource resource) {
        return _formatter.format("missing-resource", (Object)resource);
    }

    static String errorReadingResource(Resource resource, Throwable cause) {
        return _formatter.format("error-reading-resource", (Object)resource, (Object)cause);
    }

    static String unknownPublicId(Resource resource, String publicId) {
        return _formatter.format("unknown-public-id", (Object)resource, (Object)publicId);
    }

    static String serviceElementNotSupported() {
        return _formatter.getMessage("service-element-not-supported");
    }

    static String rangeError(TemplateToken token, int length) {
        return _formatter.format("range-error", (Object)token, (Object)new Integer(length));
    }

    public static String duplicateTagAttribute(String tagName, int line, String attributeName) {
        return _formatter.format("duplicate-tag-attribute", (Object)tagName, (Object)new Integer(line), (Object)attributeName);
    }

    public static Object listenerBindingUnsupported(Location location) {
        return _formatter.format("listener-binding-unsupported", (Object)HiveMind.getLocationString((Object)location));
    }
}

