/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.multipart;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.multipart.AbstractMultipartDecoder;
import org.apache.tapestry.multipart.MultipartMessages;
import org.apache.tapestry.multipart.ServletMultipartDecoder;
import org.apache.tapestry.multipart.UploadFormParametersWrapper;

public class MultipartDecoderImpl
extends AbstractMultipartDecoder
implements ServletMultipartDecoder {
    protected long _maxSize = 10000000L;

    public HttpServletRequest decode(HttpServletRequest request) {
        this._encoding = request.getCharacterEncoding();
        ServletFileUpload upload = this.createFileUpload();
        try {
            List fileItems = upload.parseRequest(request);
            this.processFileItems(fileItems);
        }
        catch (FileUploadException ex) {
            throw new ApplicationRuntimeException(MultipartMessages.unableToDecode(ex), (Throwable)ex);
        }
        Map parameterMap = this.buildParameterMap();
        return new UploadFormParametersWrapper(request, parameterMap);
    }

    private ServletFileUpload createFileUpload() {
        DiskFileItemFactory factory = new DiskFileItemFactory(this._thresholdSize, new File(this._repositoryPath));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(this._maxSize);
        if (this._encoding != null) {
            upload.setHeaderEncoding(this._encoding);
        }
        return upload;
    }

    public void setMaxSize(long maxSize) {
        this._maxSize = maxSize;
    }
}

