/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.link;

import java.util.HashMap;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.services.ComponentRenderWorker;

public class DirectLinkWorker
implements ComponentRenderWorker {
    private IScriptSource _scriptSource;
    private ClasspathResource _script;
    private ClassResolver _resolver;
    private String _scriptPath;

    public void renderComponent(IRequestCycle cycle, IComponent component) {
        if (cycle.isRewinding()) {
            return;
        }
        if (!ILinkComponent.class.isInstance(component) || !IDirect.class.isInstance(component)) {
            return;
        }
        IDirect direct = (IDirect)component;
        if (!direct.isAsync() && !direct.isJson()) {
            return;
        }
        PageRenderSupport prs = TapestryUtils.getPageRenderSupport(cycle, component);
        if (prs == null) {
            return;
        }
        HashMap<String, Object> parms = new HashMap<String, Object>();
        parms.put("component", component);
        parms.put("json", direct.isJson());
        this._scriptSource.getScript((Resource)this._script).execute(cycle, prs, parms);
    }

    public void renderBody(IRequestCycle cycle, Body component) {
    }

    public void initialize() {
        Defense.notNull((Object)this._resolver, (String)"Classpath Resolver");
        Defense.notNull((Object)this._scriptPath, (String)"Script path");
        this._script = new ClasspathResource(this._resolver, this._scriptPath);
    }

    public void setScriptSource(IScriptSource source) {
        this._scriptSource = source;
    }

    public void setScript(String path) {
        this._scriptPath = path;
    }

    public void setClassResolver(ClassResolver resolver) {
        this._resolver = resolver;
    }
}

