/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.json.JSONLiteral;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.util.RegexpMatcher;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class Pattern
extends BaseValidator {
    private RegexpMatcher _matcher = new RegexpMatcher();
    private String _pattern;

    public Pattern() {
    }

    public Pattern(String initializer) {
        super(initializer);
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        String input = (String)object;
        if (!this._matcher.matches(this._pattern, input)) {
            throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.PATTERN_MISMATCH);
        }
    }

    private String buildMessage(ValidationMessages messages, IFormComponent field) {
        return messages.formatValidationMessage(this.getMessage(), "regex-mismatch", new Object[]{this._pattern, field.getDisplayName()});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        String pattern = this._matcher.getEscapedPatternString(this._pattern);
        JSONObject profile = context.getProfile();
        if (!profile.has("constraints")) {
            profile.put("constraints", new JSONObject());
        }
        JSONObject cons = profile.getJSONObject("constraints");
        this.accumulateProperty(cons, field.getClientId(), new JSONLiteral("[tapestry.form.validation.isValidPattern,\"" + pattern + "\"]"));
        this.accumulateProfileProperty(field, profile, "constraints", this.buildMessage(context, field));
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }
}

