/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.json.JSONLiteral;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class MinLength
extends BaseValidator {
    private int _minLength;

    public MinLength() {
    }

    public MinLength(String initializer) {
        super(initializer);
    }

    public void setMinLength(int minLength) {
        this._minLength = minLength;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        String string = (String)object;
        if (string.length() < this._minLength) {
            throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.MINIMUM_WIDTH);
        }
    }

    protected String buildMessage(ValidationMessages messages, IFormComponent field) {
        return messages.formatValidationMessage(this.getMessage(), "field-too-short", new Object[]{new Integer(this._minLength), field.getDisplayName()});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        JSONObject profile = context.getProfile();
        if (!profile.has("constraints")) {
            profile.put("constraints", new JSONObject());
        }
        JSONObject cons = profile.getJSONObject("constraints");
        this.accumulateProperty(cons, field.getClientId(), new JSONLiteral("[dojo.validate.isText,{minlength:" + this._minLength + "}]"));
        this.accumulateProfileProperty(field, profile, "constraints", this.buildMessage(context, field));
    }
}

