/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import java.util.Date;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.translator.DateTranslator;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.json.JSONLiteral;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.util.Strftime;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class MinDate
extends BaseValidator {
    private Date _minDate;

    public MinDate() {
    }

    public MinDate(String initializer) {
        super(initializer);
    }

    public void setMinDate(Date minDate) {
        this._minDate = minDate;
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        Date date = (Date)object;
        DateTranslator translator = (DateTranslator)this.getFieldTranslator(field, DateTranslator.class);
        if (date.before(this._minDate)) {
            throw new ValidatorException(this.buildMessage(messages, field, translator), ValidationConstraint.TOO_SMALL);
        }
    }

    private String buildMessage(ValidationMessages messages, IFormComponent field, DateTranslator translator) {
        return messages.formatValidationMessage(this.getMessage(), "date-too-early", new Object[]{field.getDisplayName(), translator != null ? translator.format(field, messages.getLocale(), this._minDate) : this._minDate});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        DateTranslator translator = (DateTranslator)this.getFieldTranslator(field, DateTranslator.class);
        if (translator == null) {
            return;
        }
        JSONObject profile = context.getProfile();
        context.addInitializationScript(field, "dojo.require(\"tapestry.form.datetime\");");
        if (!profile.has("constraints")) {
            profile.put("constraints", new JSONObject());
        }
        JSONObject cons = profile.getJSONObject("constraints");
        this.accumulateProperty(cons, field.getClientId(), new JSONLiteral("[tapestry.form.datetime.isValidDate,{min:" + JSONObject.quote(translator.format(field, context.getLocale(), this._minDate)) + "," + "format:" + JSONObject.quote(Strftime.convertToPosixFormat(translator.getPattern())) + "}]"));
        this.accumulateProfileProperty(field, profile, "constraints", this.buildMessage(context, field, translator));
    }
}

