/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.translator;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.translator.FormatTranslator;
import org.apache.tapestry.json.JSONLiteral;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.valid.ValidationConstraint;

public class NumberTranslator
extends FormatTranslator {
    private boolean _omitZero = true;

    public NumberTranslator() {
    }

    public NumberTranslator(String initializer) {
        PropertyUtils.configureProperties((Object)this, (String)initializer);
    }

    protected String formatObject(IFormComponent field, Locale locale, Object object) {
        Number number = (Number)object;
        if (this._omitZero && number.doubleValue() == 0.0) {
            return "";
        }
        return super.formatObject(field, locale, object);
    }

    protected String defaultPattern() {
        return "#";
    }

    protected Format getFormat(Locale locale) {
        return this.getDecimalFormat(locale);
    }

    public DecimalFormat getDecimalFormat(Locale locale) {
        return new DecimalFormat(this.getPattern(), new DecimalFormatSymbols(locale));
    }

    protected String getMessageKey() {
        return "invalid-numeric-format";
    }

    protected Object[] getMessageParameters(Locale locale, String label) {
        String pattern = this.getDecimalFormat(locale).toLocalizedPattern();
        return new Object[]{label, pattern};
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        super.renderContribution(writer, cycle, context, field);
        String message = this.buildMessage(context, field, this.getMessageKey());
        JSONObject profile = context.getProfile();
        if (!profile.has("constraints")) {
            profile.put("constraints", new JSONObject());
        }
        JSONObject cons = profile.getJSONObject("constraints");
        DecimalFormat format = this.getDecimalFormat(context.getLocale());
        cons.accumulate(field.getClientId(), new JSONLiteral("[dojo.validate.isRealNumber,{" + (format.getMaximumFractionDigits() > 0 ? "" : "places:" + format.getMaximumFractionDigits() + ",") + "decimal:" + JSONObject.quote(format.getDecimalFormatSymbols().getDecimalSeparator()) + "," + "separator:" + JSONObject.quote(format.getDecimalFormatSymbols().getGroupingSeparator()) + "}]"));
        this.accumulateProfileProperty(field, profile, "constraints", message);
    }

    protected ValidationConstraint getConstraint() {
        return ValidationConstraint.NUMBER_FORMAT;
    }

    public void setOmitZero(boolean omitZero) {
        this._omitZero = omitZero;
    }
}

