/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.translator;

import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.translator.AbstractTranslator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public abstract class FormatTranslator
extends AbstractTranslator {
    private String _pattern;

    public FormatTranslator() {
        this._pattern = this.defaultPattern();
    }

    public FormatTranslator(String initializer) {
        PropertyUtils.configureProperties((Object)this, (String)initializer);
        if (HiveMind.isBlank((String)this._pattern)) {
            this._pattern = this.defaultPattern();
        }
    }

    protected abstract String defaultPattern();

    protected String formatObject(IFormComponent field, Locale locale, Object object) {
        Format format = this.getFormat(locale);
        return format.format(object);
    }

    protected Object parseText(IFormComponent field, ValidationMessages messages, String text) throws ValidatorException {
        Format format = this.getFormat(messages.getLocale());
        try {
            return format.parseObject(text);
        }
        catch (ParseException ex) {
            throw new ValidatorException(this.buildMessage(messages, field, this.getMessageKey()), this.getConstraint());
        }
    }

    protected abstract ValidationConstraint getConstraint();

    protected abstract Format getFormat(Locale var1);

    protected abstract String getMessageKey();

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }
}

