/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.hivemind.HiveMind;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.multipart.MultipartDecoder;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.ValidatorException;

public abstract class Upload
extends AbstractFormComponent
implements ValidatableField {
    public abstract void setFile(IUploadFile var1);

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm();
        form.setEncodingType("multipart/form-data");
        this.renderDelegatePrefix(writer, cycle);
        writer.beginEmpty("input");
        writer.attribute("type", "file");
        writer.attribute("name", this.getName());
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.getValidatableFieldSupport().renderContributions(this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
        this.renderDelegateSuffix(writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IUploadFile file = this.getDecoder().getFileUpload(this.getName());
        if (HiveMind.isBlank((String)file.getFileName())) {
            file = null;
        }
        try {
            this.getValidatableFieldSupport().validate(this, writer, cycle, file);
            this.setFile(file);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public abstract MultipartDecoder getDecoder();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired(this);
    }
}

