/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.hivemind.HiveMind;
import org.apache.hivemind.impl.MessageFormatter;
import org.apache.tapestry.IComponent;

final class FormMessages {
    private static final MessageFormatter _formatter = new MessageFormatter(FormMessages.class);

    private FormMessages() {
    }

    static String formTooManyIds(IComponent form, int actualCount, IComponent component) {
        return _formatter.format("form-too-many-ids", (Object)form.getExtendedId(), (Object)new Integer(actualCount), (Object)component.getExtendedId());
    }

    static String formIdMismatch(IComponent form, int mismatchIndex, String expectedId, String actualId, IComponent component) {
        return _formatter.format("form-id-mismatch", new Object[]{form.getExtendedId(), new Integer(mismatchIndex + 1), expectedId, actualId, component.getExtendedId()});
    }

    static String formTooFewIds(IComponent form, int remainingCount, String nextExpectedId) {
        return _formatter.format("form-too-few-ids", (Object)form.getExtendedId(), (Object)new Integer(remainingCount), (Object)nextExpectedId);
    }

    static String encodingTypeContention(IComponent form, String establishedEncodingType, String newEncodingType) {
        return _formatter.format("encoding-type-contention", (Object)form.getExtendedId(), (Object)establishedEncodingType, (Object)newEncodingType);
    }

    static String fieldAlreadyPrerendered(IComponent field) {
        return _formatter.format("field-already-prerendered", (Object)field);
    }

    static String linkSubmitMayNotNest(IComponent inner, IComponent outer) {
        return _formatter.format("link-submit-may-not-nest", (Object)inner.getExtendedId(), (Object)outer.getExtendedId(), (Object)HiveMind.getLocationString((Object)outer));
    }
}

