/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.hivemind.Location;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.RenderRewoundException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.DirectServiceParameter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.FormSupport;
import org.apache.tapestry.form.FormSupportImpl;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.listener.ListenerInvoker;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.web.WebResponse;

public abstract class Form
extends AbstractComponent
implements IForm,
IDirect {
    private String _name;
    private FormSupport _formSupport;
    private IRender _renderInformalParameters;

    public boolean isRewinding() {
        if (!this.isRendering()) {
            throw Tapestry.createRenderOnlyPropertyException(this, "rewinding");
        }
        return this._formSupport.isRewinding();
    }

    public abstract IEngineService getDirectService();

    public boolean getRequiresSession() {
        return this.isStateful();
    }

    public String getElementId(IFormComponent component) {
        return this._formSupport.getElementId(component, component.getId());
    }

    public String getElementId(IFormComponent component, String baseId) {
        return this._formSupport.getElementId(component, baseId);
    }

    public String getName() {
        return this._name;
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        TapestryUtils.storeForm(cycle, this);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._formSupport = null;
        TapestryUtils.removeForm(cycle);
        IValidationDelegate delegate = this.getDelegate();
        if (delegate != null) {
            delegate.setFormComponent(null);
        }
        super.cleanupAfterRender(cycle);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this._formSupport = this.newFormSupport(writer, cycle);
        if (this.isRewinding()) {
            String submitType = this._formSupport.rewind();
            IActionListener listener = this.findListener(submitType);
            this.getListenerInvoker().invokeListener(listener, this, cycle);
            throw new RenderRewoundException(this);
        }
        String baseName = this.constructFormNameForDirectService(cycle);
        this._name = baseName + this.getResponse().getNamespace();
        if (this._renderInformalParameters == null) {
            this._renderInformalParameters = new RenderInformalParameters();
        }
        ILink link = this.getLink(cycle);
        this._formSupport.render(this.getMethod(), this._renderInformalParameters, link, this.getScheme(), this.getPort());
    }

    IActionListener findListener(String mode) {
        IActionListener result = null;
        if (mode.equals("cancel")) {
            result = this.getCancel();
        } else if (mode.equals("refresh")) {
            result = this.getRefresh();
        } else if (!this.getDelegate().getHasErrors()) {
            result = this.getSuccess();
        }
        if (result == null) {
            result = this.getListener();
        }
        return result;
    }

    private String constructFormNameForDirectService(IRequestCycle cycle) {
        return cycle.getUniqueId(TapestryUtils.convertTapestryIdToNMToken(this.getId()));
    }

    protected FormSupport newFormSupport(IMarkupWriter writer, IRequestCycle cycle) {
        return new FormSupportImpl(writer, cycle, this);
    }

    public void addEventHandler(FormEventType type, String functionName) {
        this._formSupport.addEventHandler(type, functionName);
    }

    public void rewind(IMarkupWriter writer, IRequestCycle cycle) {
        cycle.getResponseBuilder().render(writer, this, cycle);
    }

    public void trigger(IRequestCycle cycle) {
        cycle.rewindForm(this);
    }

    private ILink getLink(IRequestCycle cycle) {
        DirectServiceParameter parameter = new DirectServiceParameter(this);
        return this.getDirectService().getLink(true, parameter);
    }

    public abstract WebResponse getResponse();

    public abstract IValidationDelegate getDelegate();

    public abstract IActionListener getListener();

    public abstract IActionListener getSuccess();

    public abstract IActionListener getCancel();

    public abstract IActionListener getRefresh();

    public abstract String getMethod();

    public abstract boolean isStateful();

    public abstract String getScheme();

    public abstract Integer getPort();

    public void setEncodingType(String encodingType) {
        this._formSupport.setEncodingType(encodingType);
    }

    public void addHiddenValue(String name, String value) {
        this._formSupport.addHiddenValue(name, value);
    }

    public void addHiddenValue(String name, String id, String value) {
        this._formSupport.addHiddenValue(name, id, value);
    }

    public void prerenderField(IMarkupWriter writer, IComponent field, Location location) {
        this._formSupport.prerenderField(writer, field, location);
    }

    public boolean wasPrerendered(IMarkupWriter writer, IComponent field) {
        return this._formSupport.wasPrerendered(writer, field);
    }

    public void addDeferredRunnable(Runnable runnable) {
        this._formSupport.addDeferredRunnable(runnable);
    }

    public abstract ListenerInvoker getListenerInvoker();

    public void registerForFocus(IFormComponent field, int priority) {
        this._formSupport.registerForFocus(field, priority);
    }

    public JSONObject getProfile() {
        return this._formSupport.getProfile();
    }

    public boolean isFormFieldUpdating() {
        return this._formSupport.isFormFieldUpdating();
    }

    public void setFormFieldUpdating(boolean value) {
        this._formSupport.setFormFieldUpdating(value);
    }

    private class RenderInformalParameters
    implements IRender {
        private RenderInformalParameters() {
        }

        public void render(IMarkupWriter writer, IRequestCycle cycle) {
            Form.this.renderInformalParameters(writer, cycle);
        }
    }
}

