/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.TranslatedField;
import org.apache.tapestry.form.TranslatedFieldSupport;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.form.translator.DateTranslator;
import org.apache.tapestry.valid.ValidatorException;

public abstract class DatePicker
extends AbstractFormComponent
implements TranslatedField {
    private static final String SYM_NAME = "name";
    private static final String SYM_FORMNAME = "formName";
    private static final String SYM_MONTHNAMES = "monthNames";
    private static final String SYM_SHORT_MONTHNAMES = "shortMonthNames";
    private static final String SYM_WEEKDAYNAMES = "weekDayNames";
    private static final String SYM_SHORT_WEEKDAYNAMES = "shortWeekDayNames";
    private static final String SYM_FIRSTDAYINWEEK = "firstDayInWeek";
    private static final String SYM_MINDAYSINFIRSTWEEK = "minimalDaysInFirstWeek";
    private static final String SYM_FORMAT = "format";
    private static final String SYM_INCL_WEEK = "includeWeek";
    private static final String SYM_CLEAR_BUTTON_LABEL = "clearButtonLabel";
    private static final String SYM_VALUE = "value";
    private static final String SYM_BUTTONONCLICKHANDLER = "buttonOnclickHandler";

    public abstract Date getValue();

    public abstract void setValue(Date var1);

    public abstract boolean isDisabled();

    public abstract boolean getIncludeWeek();

    public abstract IAsset getIcon();

    public abstract IScript getScript();

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport(cycle, this);
        boolean disabled = this.isDisabled();
        DateTranslator translator = (DateTranslator)this.getTranslator();
        Locale locale = this.getPage().getLocale();
        SimpleDateFormat format = translator.getDateFormat(locale);
        DateFormatSymbols dfs = format.getDateFormatSymbols();
        Calendar cal = Calendar.getInstance(locale);
        String name = this.getName();
        String value = this.getTranslatedFieldSupport().format(this, this.getValue());
        HashMap<String, Object> symbols = new HashMap<String, Object>();
        symbols.put(SYM_NAME, name);
        symbols.put(SYM_FORMAT, format.toPattern());
        symbols.put(SYM_INCL_WEEK, this.getIncludeWeek() ? Boolean.TRUE : Boolean.FALSE);
        symbols.put(SYM_MONTHNAMES, this.makeStringList(dfs.getMonths(), 0, 12));
        symbols.put(SYM_SHORT_MONTHNAMES, this.makeStringList(dfs.getShortMonths(), 0, 12));
        symbols.put(SYM_WEEKDAYNAMES, this.makeStringList(dfs.getWeekdays(), 1, 8));
        symbols.put(SYM_SHORT_WEEKDAYNAMES, this.makeStringList(dfs.getShortWeekdays(), 1, 8));
        symbols.put(SYM_FIRSTDAYINWEEK, new Integer(cal.getFirstDayOfWeek() - 1));
        symbols.put(SYM_MINDAYSINFIRSTWEEK, new Integer(cal.getMinimalDaysInFirstWeek()));
        symbols.put(SYM_CLEAR_BUTTON_LABEL, this.getMessages().getMessage("clear"));
        symbols.put(SYM_FORMNAME, this.getForm().getName());
        symbols.put(SYM_VALUE, this.getValue());
        this.getScript().execute(cycle, pageRenderSupport, symbols);
        this.renderDelegatePrefix(writer, cycle);
        writer.beginEmpty("input");
        writer.attribute("type", "text");
        writer.attribute(SYM_NAME, name);
        writer.attribute(SYM_VALUE, value);
        writer.attribute("title", format.toLocalizedPattern());
        if (disabled) {
            writer.attribute("disabled", "disabled");
        }
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.getTranslatedFieldSupport().renderContributions(this, writer, cycle);
        this.getValidatableFieldSupport().renderContributions(this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.printRaw("&nbsp;");
        if (!disabled) {
            writer.begin("a");
            writer.attribute("href", (String)symbols.get(SYM_BUTTONONCLICKHANDLER));
        }
        IAsset icon = this.getIcon();
        writer.beginEmpty("img");
        writer.attribute("src", icon.buildURL());
        writer.attribute("alt", this.getMessages().getMessage("alt"));
        writer.attribute("border", 0);
        if (!disabled) {
            writer.end();
        }
        this.renderDelegateSuffix(writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        try {
            Date date = (Date)this.getTranslatedFieldSupport().parse(this, value);
            this.getValidatableFieldSupport().validate(this, writer, cycle, date);
            this.setValue(date);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    private String makeStringList(String[] a, int offset, int length) {
        StringBuffer b = new StringBuffer();
        for (int i = offset; i < length; ++i) {
            b.append('\"');
            char[] ch = a[i].toCharArray();
            for (int j = 0; j < ch.length; ++j) {
                if (ch[j] < '\u0080') {
                    b.append(ch[j]);
                    continue;
                }
                b.append(DatePicker.escape(ch[j]));
            }
            b.append('\"');
            if (i >= length - 1) continue;
            b.append(", ");
        }
        return b.toString();
    }

    private static String escape(char c) {
        char unescapedChar = c;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            b.append(Integer.toHexString(unescapedChar & 0xF).toUpperCase());
            unescapedChar = (char)(unescapedChar >>> 4);
        }
        b.append("u\\");
        return b.reverse().toString();
    }

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public abstract TranslatedFieldSupport getTranslatedFieldSupport();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired(this);
    }
}

