/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.error;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.error.ErrorMessages;
import org.apache.tapestry.error.ExceptionPresenter;
import org.apache.tapestry.error.RequestExceptionReporter;
import org.apache.tapestry.services.ResponseRenderer;

public class ExceptionPresenterImpl
implements ExceptionPresenter {
    private RequestExceptionReporter _requestExceptionReporter;
    private ResponseRenderer _responseRenderer;
    private String _exceptionPageName;
    private boolean _verbose;

    public void presentException(IRequestCycle cycle, Throwable cause) {
        try {
            IPage exceptionPage = cycle.getPage(this._exceptionPageName);
            PropertyUtils.write((Object)exceptionPage, (String)"exception", (Object)cause);
            cycle.activate(exceptionPage);
            this._responseRenderer.renderResponse(cycle);
        }
        catch (Throwable ex) {
            this._requestExceptionReporter.reportRequestException(ErrorMessages.unableToProcessClientRequest(cause), cause);
            this._requestExceptionReporter.reportRequestException(ErrorMessages.unableToPresentExceptionPage(ex), ex);
            throw new ApplicationRuntimeException(ex.getMessage(), ex);
        }
        if (this._verbose) {
            this._requestExceptionReporter.reportRequestException(ErrorMessages.unableToProcessClientRequest(cause), cause);
        }
    }

    public void setExceptionPageName(String exceptionPageName) {
        this._exceptionPageName = exceptionPageName;
    }

    public void setRequestExceptionReporter(RequestExceptionReporter requestExceptionReporter) {
        this._requestExceptionReporter = requestExceptionReporter;
    }

    public void setResponseRenderer(ResponseRenderer responseRenderer) {
        this._responseRenderer = responseRenderer;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }
}

