/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.engine.state.ApplicationStateManager;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.spec.InjectSpecification;

public class InjectStateWorker
implements InjectEnhancementWorker {
    private ApplicationStateManager _applicationStateManager;

    public void performEnhancement(EnhancementOperation op, InjectSpecification spec) {
        this.injectState(op, spec.getObject(), spec.getProperty(), spec.getLocation());
    }

    void injectState(EnhancementOperation op, String objectName, String propertyName, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)objectName, (String)"objectName");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Class propertyType = EnhanceUtils.extractPropertyType(op, propertyName, null);
        String fieldName = "_$" + propertyName;
        op.claimProperty(propertyName);
        op.addField(fieldName, propertyType);
        String managerField = op.addInjectedField("_$applicationStateManager", ApplicationStateManager.class, this._applicationStateManager);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if ({0} == null)", (Object)fieldName);
        builder.addln("  {0} = ({1}) {2}.get(\"{3}\");", new Object[]{fieldName, ClassFabUtils.getJavaClassName((Class)propertyType), managerField, objectName});
        builder.addln("return {0};", (Object)fieldName);
        builder.end();
        String methodName = op.getAccessorMethodName(propertyName);
        MethodSignature sig = new MethodSignature(propertyType, methodName, null, null);
        op.addMethod(1, sig, builder.toString(), location);
        builder.clear();
        builder.begin();
        builder.addln("{0}.store(\"{1}\", $1);", (Object)managerField, (Object)objectName);
        builder.addln("{0} = $1;", (Object)fieldName);
        builder.end();
        sig = new MethodSignature(Void.TYPE, EnhanceUtils.createMutatorMethodName(propertyName), new Class[]{propertyType}, null);
        op.addMethod(1, sig, builder.toString(), location);
        op.extendMethodImplementation(PageDetachListener.class, EnhanceUtils.PAGE_DETACHED_SIGNATURE, fieldName + " = null;");
    }

    public void setApplicationStateManager(ApplicationStateManager applicationStateManager) {
        this._applicationStateManager = applicationStateManager;
    }
}

