/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.services.ComponentRenderWorker;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectRenderWorker
implements EnhancementWorker {
    public static final String PROPERTY_NAME = "renderWorker";
    private ErrorLog _errorLog;
    private ComponentRenderWorker _renderWorker;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        try {
            this.injectRenderWorker(op, spec);
        }
        catch (Exception ex) {
            this._errorLog.error(EnhanceMessages.errorAddingProperty(PROPERTY_NAME, op.getBaseClass(), ex), spec.getLocation(), (Throwable)ex);
        }
    }

    public void injectRenderWorker(EnhancementOperation op, IComponentSpecification spec) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)spec, (String)"spec");
        op.claimReadonlyProperty(PROPERTY_NAME);
        String fieldName = op.addInjectedField("_$renderWorker", ComponentRenderWorker.class, this._renderWorker);
        EnhanceUtils.createSimpleAccessor(op, fieldName, PROPERTY_NAME, ComponentRenderWorker.class, spec.getLocation());
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setRenderWorker(ComponentRenderWorker worker) {
        this._renderWorker = worker;
    }
}

