/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.IPage;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.spec.InjectSpecification;

public class InjectPageWorker
implements InjectEnhancementWorker {
    public void performEnhancement(EnhancementOperation op, InjectSpecification spec) {
        this.performEnhancement(op, spec.getObject(), spec.getProperty(), spec.getLocation());
    }

    public void performEnhancement(EnhancementOperation op, String pageName, String propertyName, Location location) {
        Class<Object> propertyType = op.getPropertyType(propertyName);
        if (propertyType == null) {
            propertyType = Object.class;
        } else if (propertyType.isPrimitive()) {
            throw new ApplicationRuntimeException(EnhanceMessages.wrongTypeForPageInjection(propertyName, propertyType), null, location, null);
        }
        op.claimReadonlyProperty(propertyName);
        MethodSignature sig = new MethodSignature(propertyType, op.getAccessorMethodName(propertyName), null, null);
        BodyBuilder builder = new BodyBuilder();
        builder.add("return ");
        if (!propertyType.isAssignableFrom(IPage.class)) {
            builder.add("({0})", (Object)propertyType.getName());
        }
        builder.add("getPage().getRequestCycle().getPage(\"{0}\");", (Object)pageName);
        op.addMethod(1, sig, builder.toString(), location);
    }
}

