/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.services.InjectedValueProvider;
import org.apache.tapestry.spec.InjectSpecification;

public class InjectObjectWorker
implements InjectEnhancementWorker {
    private InjectedValueProvider _provider;

    public void performEnhancement(EnhancementOperation op, InjectSpecification is) {
        String name = is.getProperty();
        String objectReference = is.getObject();
        Location location = is.getLocation();
        this.injectObject(op, objectReference, name, location);
    }

    public void injectObject(EnhancementOperation op, String objectReference, String propertyName, Location location) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)propertyName, (String)"propertyName");
        Defense.notNull((Object)objectReference, (String)"objectReference");
        Class<Object> propertyType = op.getPropertyType(propertyName);
        if (propertyType == null) {
            propertyType = Object.class;
        }
        op.claimReadonlyProperty(propertyName);
        Object injectedValue = this._provider.obtainValue(objectReference, location);
        if (injectedValue == null) {
            throw new ApplicationRuntimeException(EnhanceMessages.locatedValueIsNull(objectReference), location, null);
        }
        if (!propertyType.isAssignableFrom(injectedValue.getClass())) {
            throw new ApplicationRuntimeException(EnhanceMessages.incompatibleInjectType(objectReference, injectedValue, propertyType), location, null);
        }
        String fieldName = op.addInjectedField("_$" + propertyName, propertyType, injectedValue);
        String methodName = EnhanceUtils.createAccessorMethodName(propertyName);
        op.addMethod(1, new MethodSignature(propertyType, methodName, null, null), "return " + fieldName + ";", location);
    }

    public void setProvider(InjectedValueProvider provider) {
        this._provider = provider;
    }
}

