/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.services.impl.ComponentEventInvoker;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectEventInvokerWorker
implements EnhancementWorker {
    public static final String PROPERTY_NAME = "eventInvoker";
    private ErrorLog _errorLog;
    private ComponentEventInvoker _invoker;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        try {
            this.injectEventInvoker(op, spec);
        }
        catch (Exception ex) {
            this._errorLog.error(EnhanceMessages.errorAddingProperty(PROPERTY_NAME, op.getBaseClass(), ex), spec.getLocation(), (Throwable)ex);
        }
    }

    public void injectEventInvoker(EnhancementOperation op, IComponentSpecification spec) {
        Defense.notNull((Object)op, (String)"op");
        Defense.notNull((Object)spec, (String)"spec");
        op.claimReadonlyProperty(PROPERTY_NAME);
        String fieldName = op.addInjectedField("_$eventInvoker", ComponentEventInvoker.class, this._invoker);
        EnhanceUtils.createSimpleAccessor(op, fieldName, PROPERTY_NAME, ComponentEventInvoker.class, spec.getLocation());
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setComponentEventInvoker(ComponentEventInvoker invoker) {
        this._invoker = invoker;
    }
}

