/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hivemind.ErrorLog;
import org.apache.hivemind.Location;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhancedClassValidator;
import org.apache.tapestry.spec.IComponentSpecification;

public class EnhancedClassValidatorImpl
implements EnhancedClassValidator {
    private ErrorLog _errorLog;

    public void validate(Class baseClass, Class enhancedClass, IComponentSpecification specification) {
        HashSet<MethodSignature> implementedMethods = new HashSet<MethodSignature>();
        HashMap interfaceMethods = new HashMap();
        Location location = specification.getLocation();
        Class current = enhancedClass;
        do {
            this.addInterfaceMethods(current, interfaceMethods);
            Method[] methods = current.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                MethodSignature s = new MethodSignature(m);
                boolean isAbstract = Modifier.isAbstract(m.getModifiers());
                if (isAbstract) {
                    if (interfaceMethods.containsKey(s) || implementedMethods.contains(s)) continue;
                    this._errorLog.error(EnhanceMessages.noImplForAbstractMethod(m, current, baseClass, enhancedClass), location, null);
                }
                implementedMethods.add(s);
            }
        } while ((current = current.getSuperclass()) != null && current != Object.class);
        for (Map.Entry entry : interfaceMethods.entrySet()) {
            MethodSignature sig = (MethodSignature)entry.getKey();
            if (implementedMethods.contains(sig)) continue;
            Method method = (Method)entry.getValue();
            this._errorLog.error(EnhanceMessages.unimplementedInterfaceMethod(method, baseClass, enhancedClass), location, null);
        }
    }

    private void addInterfaceMethods(Class current, Map interfaceMethods) {
        Class<?>[] interfaces = current.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.addMethodsFromInterface(interfaces[i], interfaceMethods);
        }
    }

    private void addMethodsFromInterface(Class interfaceClass, Map interfaceMethods) {
        Method[] methods = interfaceClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodSignature sig = new MethodSignature(methods[i]);
            if (interfaceMethods.containsKey(sig)) continue;
            interfaceMethods.put(sig, methods[i]);
        }
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

