/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.Map;
import org.apache.hivemind.ErrorLog;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.enhance.InjectEnhancementWorker;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.InjectSpecification;

public class DispatchToInjectWorker
implements EnhancementWorker {
    private ErrorLog _errorLog;
    private Map _injectWorkers;

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        for (InjectSpecification is : spec.getInjectSpecifications()) {
            this.invokeWorker(op, is);
        }
    }

    private void invokeWorker(EnhancementOperation op, InjectSpecification spec) {
        try {
            InjectEnhancementWorker worker = (InjectEnhancementWorker)this._injectWorkers.get(spec.getType());
            if (worker == null) {
                this._errorLog.error(EnhanceMessages.unknownInjectType(spec.getProperty(), spec.getType()), spec.getLocation(), null);
                return;
            }
            worker.performEnhancement(op, spec);
        }
        catch (Exception ex) {
            this._errorLog.error(EnhanceMessages.errorAddingProperty(spec.getProperty(), op.getBaseClass(), ex), spec.getLocation(), (Throwable)ex);
        }
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }

    public void setInjectWorkers(Map injectWorkers) {
        this._injectWorkers = injectWorkers;
    }
}

