/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hivemind.Location;
import org.apache.hivemind.internal.Module;
import org.apache.tapestry.enhance.EnhanceMessages;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IComponentSpecification;

public class AutowireWorker
implements EnhancementWorker {
    private final Log _log;
    private final Module _module;

    public AutowireWorker(Module module, Log log) {
        this._module = module;
        this._log = log;
    }

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        List propertyNames = op.findUnclaimedAbstractProperties();
        for (String propertyName : propertyNames) {
            Class<Object> propertyType = op.getPropertyType(propertyName);
            if (propertyType == null) {
                propertyType = Object.class;
            }
            if (!op.canClaimAsReadOnlyProperty(propertyName) || !this._module.containsService(propertyType)) continue;
            Object serviceProxy = this._module.getService(propertyType);
            Location location = spec.getLocation();
            this._log.debug((Object)EnhanceMessages.autowiring(propertyName, spec, serviceProxy));
            String fieldName = op.addInjectedField("_$" + propertyName, propertyType, serviceProxy);
            EnhanceUtils.createSimpleAccessor(op, fieldName, propertyName, propertyType, location);
            op.claimReadonlyProperty(propertyName);
        }
    }
}

