/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirectEvent;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.StaleSessionException;
import org.apache.tapestry.engine.DirectEventServiceParameter;
import org.apache.tapestry.engine.EngineMessages;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.event.BrowserEvent;
import org.apache.tapestry.services.LinkFactory;
import org.apache.tapestry.services.ResponseRenderer;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebSession;

public class DirectEventService
implements IEngineService {
    private ResponseRenderer _responseRenderer;
    private LinkFactory _linkFactory;
    private WebRequest _request;
    private IRequestCycle _requestCycle;

    public ILink getLink(boolean post, Object parameter) {
        Defense.isAssignable((Object)parameter, DirectEventServiceParameter.class, (String)"parameter");
        DirectEventServiceParameter dsp = (DirectEventServiceParameter)parameter;
        IDirectEvent component = dsp.getDirect();
        IPage activePage = this._requestCycle.getPage();
        IPage componentPage = component.getPage();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        boolean stateful = this._request.getSession(false) != null;
        parameters.put("page", activePage.getPageName());
        parameters.put("component", component.getIdPath());
        parameters.put("container", componentPage == activePage ? null : componentPage.getPageName());
        parameters.put("session", stateful ? "T" : null);
        if (dsp.getUpdateParts() != null && dsp.getUpdateParts().length > 0) {
            parameters.put("updateParts", dsp.getUpdateParts());
        }
        if (dsp.isJSON()) {
            parameters.put("json", String.valueOf(dsp.isJSON()));
        }
        parameters.put("sp", dsp.getServiceParameters());
        return this._linkFactory.constructLink(this, post, parameters, true);
    }

    public void service(IRequestCycle cycle) throws IOException {
        WebSession session;
        String componentId = cycle.getParameter("component");
        String componentPageName = cycle.getParameter("container");
        String activePageName = cycle.getParameter("page");
        boolean activeSession = cycle.getParameter("session") != null;
        IPage page = cycle.getPage(activePageName);
        cycle.activate(page);
        IPage componentPage = componentPageName == null ? page : cycle.getPage(componentPageName);
        IComponent component = componentPage.getNestedComponent(componentId);
        IDirectEvent direct = null;
        try {
            direct = (IDirectEvent)component;
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(EngineMessages.wrongComponentType(component, IDirectEvent.class), (Object)component, null, (Throwable)ex);
        }
        if (activeSession && direct.isStateful() && ((session = this._request.getSession(false)) == null || session.isNew())) {
            throw new StaleSessionException(EngineMessages.requestStateSession(direct), componentPage);
        }
        Object[] parameters = this._linkFactory.extractListenerParameters(cycle);
        this.triggerComponent(cycle, direct, parameters);
        this._responseRenderer.renderResponse(cycle);
    }

    protected void triggerComponent(IRequestCycle cycle, IDirectEvent direct, Object[] parameters) {
        if (!BrowserEvent.hasBrowserEvent(cycle)) {
            throw new ApplicationRuntimeException(EngineMessages.noBrowserEvent());
        }
        BrowserEvent event = new BrowserEvent(cycle);
        Object[] parms = new Object[parameters.length + 1];
        System.arraycopy(parameters, 0, parms, 0, parameters.length);
        parms[parms.length - 1] = event;
        cycle.setListenerParameters(parms);
        direct.triggerEvent(cycle, event);
    }

    public String getName() {
        return "directevent";
    }

    public void setResponseRenderer(ResponseRenderer responseRenderer) {
        this._responseRenderer = responseRenderer;
    }

    public void setLinkFactory(LinkFactory linkFactory) {
        this._linkFactory = linkFactory;
    }

    public void setRequest(WebRequest request) {
        this._request = request;
    }

    public void setRequestCycle(IRequestCycle requestCycle) {
        this._requestCycle = requestCycle;
    }
}

